% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_proj.R
\name{coord_proj}
\alias{coord_proj}
\title{Coordinate System with Transformed Limits for Custom Projections}
\usage{
coord_proj(
  crs = NULL,
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  default_crs = "EPSG:4326",
  ...
)
}
\arguments{
\item{crs}{A character string specifying the coordinate reference system (CRS) for the projection
(e.g., `"EPSG:4326"` or custom projections like `"+proj=merc"`).}

\item{xlim}{Longitude range (in degrees) to display, as a numeric vector of length 2.}

\item{ylim}{Latitude range (in degrees) to display, as a numeric vector of length 2.}

\item{expand}{Logical, whether to expand the plot limits. Default is `TRUE`.}

\item{default_crs}{A character string specifying the CRS of the input `xlim` and `ylim`.
Default is `"EPSG:4326"`.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:coord_sf]{ggplot2::coord_sf()}}.}
}
\value{
A ggplot2 \code{coord_sf} object with the transformed limits.
}
\description{
`coord_proj` is a wrapper around \code{\link[ggplot2:coord_sf]{ggplot2::coord_sf()}}.
It simplifies specifying map limits (`xlim`, `ylim`) in longitude and latitude (WGS84 CRS)
and automatically transforms them into the specified CRS for accurate projections.

This function extends the functionality of \code{coord_sf()} to seamlessly handle user-specified
geographic boundaries in any projection, ensuring accurate mapping.
}
\examples{

# World map with default projection and limits
ggplot() +
  geom_world() +
  coord_proj(
    crs = "+proj=longlat +datum=WGS84",
    xlim = c(-180, 180),
    ylim = c(-90, 90),
    expand=FALSE
  ) +
  theme_minimal()

# Focused view with Azimuthal Equidistant projection
china_proj <- "+proj=aeqd +lat_0=35 +lon_0=105 +ellps=WGS84 +units=m +no_defs"
ggplot() +
  geom_world(fill = "lightblue") +
  coord_proj(
    crs = china_proj,
    xlim = c(60, 140),
    ylim = c(-10, 50)
  ) +
  theme_minimal()

# Display a small map of the South China Sea Islands with a custom projection
ggplot() +
  geom_boundary_cn() +
  theme_bw() +
  coord_proj(
    crs = china_proj,
    expand = FALSE,
    xlim = c(105, 123),
    ylim = c(2, 23)
  )

}
\seealso{
\code{\link[ggplot2:coord_sf]{ggplot2::coord_sf}}, \code{\link[ggmapcn:geom_world]{geom_world}}
}
