% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisquare.R
\name{ggchisqtest}
\alias{ggchisqtest}
\title{Plot for Pearson's Chi-squared Test for Count Data}
\usage{
ggchisqtest(t, colaccept="lightsteelblue1", colreject="gray84", 
colstat="navyblue", alpha=0.05)
}
\arguments{
\item{t}{a list result of \code{\link{chisq.test}} of "htest" class}

\item{colaccept}{color the acceptance area of the test}

\item{colreject}{color for the rejection area of the test}

\item{colstat}{color for the test statistic vline}

\item{alpha}{default set to 0.05, choose confidence level for the plot as it is not stated in chisqtest}
}
\description{
Visualise chi-squared contingency table tests and goodness-of-fit tests.
}
\examples{
## Chi-squared test for given probabilities

x <- c(A = 20, B = 15, C = 25)
chisq_test <- chisq.test(x)
chisq_test
ggchisqtest(chisq_test)


x <- c(10, 86, 45, 38, 10)
p <- c(0.10, 0.40, 0.20, 0.20, 0.10)
chisq_test2 <- chisq.test(x, p = p)
chisq_test2
ggchisqtest(chisq_test2)



## Pearson's Chi-squared test

library(MASS)
sex_smoke <- table(survey$Sex, survey$Smoke)
chisq_test3 <- chisq.test(sex_smoke)
chisq_test3
ggchisqtest(chisq_test3)

}
