% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galamm-package.R
\docType{package}
\name{galamm-package}
\alias{galamm-package}
\title{galamm: Generalized Additive Latent and Mixed Models}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Estimates generalized additive latent and mixed models using maximum marginal likelihood, as defined in Sorensen et al. (2023) \doi{10.1007/s11336-023-09910-z}, which is an extension of Rabe-Hesketh and Skrondal (2004)'s unifying framework for multilevel latent variable modeling \doi{10.1007/BF02295939}. Efficient computation is done using sparse matrix methods, Laplace approximation, and automatic differentiation. The framework includes generalized multilevel models with heteroscedastic residuals, mixed response types, factor loadings, smoothing splines, crossed random effects, and combinations thereof. Syntax for model formulation is close to 'lme4' (Bates et al. (2015) \doi{10.18637/jss.v067.i01}) and 'PLmixed' (Rockwood and Jeon (2019) \doi{10.1080/00273171.2018.1516541}).
}
\references{
\insertRef{sorensenLongitudinalModelingAgeDependent2023}{galamm}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/LCBC-UiO/galamm}
  \item \url{https://lcbc-uio.github.io/galamm/}
  \item Report bugs at \url{https://github.com/LCBC-UiO/galamm/issues}
}

}
\author{
\strong{Maintainer}: Øystein Sørensen \email{oystein.sorensen@psykologi.uio.no} (\href{https://orcid.org/0000-0003-0724-3542}{ORCID})

Other contributors:
\itemize{
  \item Douglas Bates [contributor]
  \item Ben Bolker [contributor]
  \item Martin Maechler [contributor]
  \item Allan Leal [contributor]
  \item Fabian Scheipl [contributor]
  \item Steven Walker [contributor]
  \item Simon Wood [contributor]
}

}
\keyword{internal}
