% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{comma}
\alias{comma}
\alias{comma.character}
\alias{comma.default}
\title{Numeric vector with thousands separators}
\usage{
comma(x, digits, format = "f", big.mark = ",", ...)

\method{comma}{default}(x, digits = 2L, format = "f", big.mark = ",", ...)

\method{comma}{character}(x, digits = max(get_digits(x)), format = "f",
  big.mark = ",", ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{digits}{an integer to indicate the number of digits of the percentage string.}

\item{format}{format type passed to \code{\link{formatC}}.}

\item{big.mark}{thousands separator}

\item{...}{additional parameters passed to \code{formattable}.}
}
\description{
Numeric vector with thousands separators
}
\examples{
comma(1000000)
comma(c(1250000, 225000))
comma(c(1250000, 225000), format = "d")
comma("123,345.123")
}

