% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{prefix}
\alias{prefix}
\title{Formattable object with prefix}
\usage{
prefix(x, prefix = "", sep = "", ..., na.text = NULL)
}
\arguments{
\item{x}{an object}

\item{prefix}{a character vector put in front of each non-missing
value in \code{x} as being formatted.}

\item{sep}{separator}

\item{...}{additional parameter passed to \code{formattable}.}

\item{na.text}{text for missing values in \code{x}.}
}
\description{
Formattable object with prefix
}
\examples{
prefix(1:10, "A")
prefix(1:10, "Choice", sep = " ")
prefix(c(1:10, NA), prefix = "A", na.text = "(missing)")
prefix(rnorm(10, 10), "*", format = "d")
prefix(percent(c(0.1,0.25)), ">")
}

