% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfgam.R
\name{dfgam}
\alias{dfgam}
\title{dfgam: Degrees of Freedom Selection for GAM Models}
\usage{
dfgam(
  response,
  nl.predictors,
  other.predictors = NULL,
  smoother = "s",
  method = "AIC",
  data,
  step = NULL
)
}
\arguments{
\item{response}{The response variable as a formula.}

\item{nl.predictors}{A character vector specifying the non-linear predictors.}

\item{other.predictors}{A character vector specifying other predictors if needed.}

\item{smoother}{The type of smoothing term, currently only "s" is supported.}

\item{method}{The selection method, one of "AIC", "AICc", or "BIC".}

\item{data}{The data frame containing the variables.}

\item{step}{The step size for grid search when there are multiple non-linear predictors.}
}
\value{
A list containing the following components:
\itemize{
  \item \code{fit}: The fitted GAM model.
  \item \code{df}: A numeric vector of degrees of freedom for each non-linear predictor.
  \item \code{method}: The selection method used (AIC, AICc, or BIC).
  \item \code{nl.predictors}: The non-linear predictors used in the model.
  \item \code{other.predictors}: Other predictors used in the model if specified.
}
}
\description{
Computes the degrees of freedom for specified non-linear
predictors in a GAM model. The user can choose between AIC (Akaike Information
Criterion), AICc (AIC corrected for small sample sizes), or BIC (Bayesian
Information Criterion) as the selection criteria. This function is useful for
determining the appropriate degrees of freedom for smoothing terms in GAMs.
}
\examples{
# Load dataset
library(gam)
data(PimaIndiansDiabetes2, package="mlbench");

# Calculate degrees of freedom using AIC
df2 <- dfgam(
  response="diabetes",
  nl.predictors=c("age", "mass"),
  other.predictors=c("pedigree"),
  smoother="s",
  method="AIC",
  data=PimaIndiansDiabetes2
);

print(df2$df);

}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
