% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{model.response.feis}
\alias{model.response.feis}
\title{A function to extract the model.response}
\usage{
model.response.feis(x, ...)
}
\arguments{
\item{x}{an object of class \code{feis}.}

\item{...}{further arguments.}
}
\value{
A "\code{numeric}" of the transformed response variable of the estimation model.
}
\description{
Returns the de-trended response variable of a \code{feis} object.
}
\details{
The function provides a convenient way to return the model.response of a \code{feis} object.
This is the transformed (de-trended) variable which is used for estimation of the final model.
}
\examples{
data("mwp", package = "feisr")
feis.mod <- feis(lnw ~ marry + enrol | year,
                 data = mwp, id = "id")
y_tilde <- model.response.feis(feis.mod)

}
