% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pois.R
\name{confint_pois}
\alias{confint_pois}
\title{Poisson rate confidence intervals}
\usage{
confint_pois(
  n,
  b = 0,
  cl = 0.95,
  acc = 0.001 * (max(n - b, 0) + 1),
  lambda_min = NULL,
  lambda_max = NULL
)
}
\arguments{
\item{n}{number of events. Numeric vector of length one.}

\item{b}{expected number of background events. Numeric vector of length one
or three (see Details).}

\item{cl}{confidence level for the returned confidence interval.
A number between zero and one.}

\item{acc}{required accuracy in the confidence interval endpoints.
A positive number.}

\item{lambda_min, lambda_max}{window of Poisson rate
values for whom the Neyman belt construction is performed. Numeric vectors of
length one or \code{NULL} (see Details). For advanced users only, use the
default value (\code{NULL}) if unsure.}
}
\value{
a numeric vector of length two, containing the confidence interval
endpoints.
}
\description{
Build confidence intervals for the rate of a Poisson random variable using
the Feldman-Cousins construction (Feldman and Cousins, 1998).
}
\details{
The Feldman-Cousins confidence intervals construction
(Feldman and Cousins, 1998) provides a unified treatment for the estimation
of Poisson rates, which
produces consistent results for both the common case, where the number of
observed events \code{n} is greater than the number of background events
\code{b}, and the boundary cases, when \code{n} is equal or even less than
\code{b}. In these last cases, a naive treatment can lead to either
overcovering (that is, unnecessarily large confidence intervals;
this is the case for, \emph{e.g.}, the intervals returned from
\code{stats::poisson.test} for zero events and no background) or,
even worse, undercovering and/or non-sensical confidence intervals
(relevant examples can be found in (Feldman and Cousins, 1998)).

In order to find confidence intervals, the standard Neyman construction
is performed over a grid of values for the estimated rate. The search
interval can be controlled through the parameters \code{lambda_min} and
\code{lambda_max}; if these are left as default (\code{NULL}), they are
estimated automatically based on a rough estimate, which should be adequate
in a large majority of cases.

The argument \code{b} controls the expected number of background events,
which would differ from zero if some of the event counts are expected
to correspond to spurious events. In other words, the number of total counts
\code{n} is assumed to follow a Poisson distribution with rate
\code{lambda + b}, with \code{b} known and \code{lambda} unknown and to be
estimated.

The original reference discusses a minor correction to confidence intervals,
which ensures that the produced upper limits are decreasing functions of
\code{b}.
This is computationally intensive and not necessary for the correctness of
Feldman-Cousins confidence intervals, but may facilitate interpretation for
e.g. sensitivity analyses.
The correction can be implemented by providing a length three numeric to the
\code{b} argument, such that \code{b[[1]]} is the expected background rate as
before, while \code{b[[2]]} and \code{b[[3]]} represent a maximum value
for \code{b} and a grid step. The construction is repeated over the whole
grid of \code{b} values and the actual upper limit is chosen as the
greatest upper limit encountered in the sequence of intervals so constructed.
}
\examples{
confint_pois(n = 10, cl = 0.68)
confint_pois(n = 10, b = 5, cl = 0.68)

# Compare:
confint_pois(n = 0, cl = 0.95)
# with:
poisson.test(x = 0, conf.level = 0.95)$conf.int
}
\references{
Feldman, Gary J. and Cousins, Robert D.
"Unified approach to the classical statistical analysis of small signals"
\emph{Phys. Rev. D} \strong{57}, issue 7 (1998): 3873-3889.
}
