% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_dalex.R
\name{explain_dalex}
\alias{explain_dalex}
\title{Generate DALEX explanations for a fastml model}
\usage{
explain_dalex(
  object,
  features = NULL,
  grid_size = 20,
  shap_sample = 5,
  vi_iterations = 10,
  seed = 123,
  loss_function = NULL
)
}
\arguments{
\item{object}{A \code{fastml} object.}

\item{features}{Character vector of feature names for partial dependence (model profiles). Default NULL.}

\item{grid_size}{Number of grid points for partial dependence. Default 20.}

\item{shap_sample}{Integer number of observations from processed training data to compute SHAP values for. Default 5.}

\item{vi_iterations}{Integer. Number of permutations for variable importance (B). Default 10.}

\item{seed}{Integer. A value specifying the random seed.}

\item{loss_function}{Function. The loss function for \code{model_parts}.
\itemize{
  \item If \code{NULL} and task = 'classification', defaults to \code{DALEX::loss_cross_entropy}.
  \item If \code{NULL} and task = 'regression', defaults to \code{DALEX::loss_root_mean_square}.
}}
}
\value{
Invisibly returns a list with variable importance, optional model profiles and SHAP values.
}
\description{
Creates a DALEX explainer and computes permutation based variable importance,
partial dependence (model profiles) and Shapley values.
}
