% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity.R
\name{entities}
\alias{entities}
\alias{get_entities}
\alias{[.epiworld_entities}
\alias{entity}
\alias{get_entity_size}
\alias{get_entity_name}
\alias{entity_add_agent}
\alias{rm_entity}
\alias{add_entity}
\alias{load_agents_entities_ties}
\alias{entity_get_agents}
\alias{distribute_entity_randomly}
\alias{distribute_entity_to_set}
\alias{set_distribution_entity}
\title{Get entities}
\usage{
get_entities(model)

\method{[}{epiworld_entities}(x, i)

entity(name, prevalence, as_proportion, to_unassigned = TRUE)

get_entity_size(entity)

get_entity_name(entity)

entity_add_agent(entity, agent, model = attr(entity, "model"))

rm_entity(model, id)

add_entity(model, entity)

load_agents_entities_ties(model, agents_id, entities_id)

entity_get_agents(entity)

distribute_entity_randomly(prevalence, as_proportion, to_unassigned = TRUE)

distribute_entity_to_set(agents_ids)

set_distribution_entity(entity, distfun)
}
\arguments{
\item{model}{Model object of class \code{epiworld_model}.}

\item{x}{Object of class \code{epiworld_entities}.}

\item{i}{Integer index.}

\item{name}{Character scalar. Name of the entity.}

\item{prevalence}{Numeric scalar. Prevalence of the entity.}

\item{as_proportion}{Logical scalar. If \code{TRUE}, \code{prevalence} is interpreted
as a proportion.}

\item{to_unassigned}{Logical scalar. If \code{TRUE}, the entity is added to the
unassigned pool.}

\item{entity}{Entity object of class \code{epiworld_entity}.}

\item{agent}{Agent object of class \code{epiworld_agent}.}

\item{id}{Integer scalar. Entity id to remove (starting from zero).}

\item{agents_id}{Integer vector.}

\item{entities_id}{Integer vector.}

\item{agents_ids}{Integer vector. Ids of the agents to distribute.}

\item{distfun}{Distribution function object of class \code{epiworld_distribution_entity}.}
}
\value{
\itemize{
\item The function \code{entity} creates an entity object.
}

\itemize{
\item The function \code{get_entity_size} returns the number of agents in the entity.
}

\itemize{
\item The function \code{get_entity_name} returns the name of the entity.
}

\itemize{
\item The function \code{entity_add_agent} adds an agent to the entity.
}

\itemize{
\item The function \code{rm_entity} removes an entity from the model.
}

\itemize{
\item The function \code{load_agents_entities_ties} loads agents into entities.
}

\itemize{
\item The function \code{entity_get_agents} returns an integer vector with the agents
in the entity (ids).
}
}
\description{
Entities in \code{epiworld} are objects that can contain agents.
}
\details{
Epiworld entities are especially useful for mixing models, particularly
\link{ModelSIRMixing} and \link{ModelSEIRMixing}.
}
\examples{
# Creating a mixing model
mymodel <- ModelSIRMixing(
  name = "My model",
  n = 10000,
  prevalence = .001,
  contact_rate = 10,
  transmission_rate = .1,
  recovery_rate = 1 / 7,
  contact_matrix = matrix(c(.9, .1, .1, .9), 2, 2)
)

ent1 <- entity("First", 5000, FALSE)
ent2 <- entity("Second", 5000, FALSE)

mymodel |>
  add_entity(ent1) |>
  add_entity(ent2)

run(mymodel, ndays = 100, seed = 1912)

summary(mymodel)
}
\concept{entity-functions}
