% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.R
\name{jackknife}
\alias{jackknife}
\title{Jackkniffe test for variable contribution}
\usage{
jackknife(data, dependent, independent, user_formula = NULL, cv = 3,
          response_type = "l", weights = NULL)
}
\arguments{
\item{data}{data.frame or matrix of data to be used in model calibration.
Columns represent dependent and independent variables.}

\item{dependent}{(character) name of dependent variable.}

\item{independent}{(character) vector of name(s) of independent variable(s).}

\item{user_formula}{(character) custom formula to test. Default = NULL.}

\item{cv}{(numeric) number of folds to use for k-fold
cross-validation exercises. Default = 3.}

\item{response_type}{(character) a character string that must contain "l",
"p", "q" or a combination of them. l = lineal, q = quadratic,
p = interaction between two variables. Default = "l".}

\item{weights}{(numeric) a vector with the weights for observations.}
}
\value{
list including model performance metrics (ROC-AUC, TSS, AICc, and
deviance) for the complete model, model performance when excluding a specific
predictor, and the independent contribution of that predictor to the model.
}
\description{
The Jackknife function providing a detailed reflection of the  impact of each
variable on the overall model, considering four difference measures:
ROC-AUC, TSS, AICc, and Deviance.
}
\examples{

# Load data
data("enm_data", package = "enmpa")

jk <- jackknife(data = enm_data,
                dependent = "Sp",
                independent = c("bio_1", "bio_12"),
                user_formula = NULL,
                cv = 3, response_type = "lpq")
jk

# plot JK's results
plot_jk(jk, metric = "TSS")
plot_jk(jk, metric = "ROC_AUC")
plot_jk(jk, metric = "AIC")
plot_jk(jk, metric = "Residual_deviance")

}
