% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reindent.R
\name{reindent}
\alias{reindent}
\title{Reindent some lines of code}
\usage{
reindent(lines, rules, tab = "    ", start = 0L)
}
\arguments{
\item{lines}{Character vector with lines of text; can have internal
newlines.}

\item{rules}{Which \link[=elixir-rules]{rules} to follow. You can pass a string
from among \code{"C"}, \code{"C++"}, \code{"Lua"}, or \code{"R"}, or a list with elements:
\itemize{
\item \code{indent_more} Character vector of tokens which increase the indent level.
\item \code{indent_less} Character vector of tokens which decrease the indent level.
\item \code{indent_both} Character vector of tokens which decrease, then increase the
indent level (see Details).
\item \code{ignore} Comment and string literal delimiters (see Details).
}}

\item{tab}{Character string; what to use as an indent.}

\item{start}{Indent level to start at.}
}
\value{
Reindented lines as a character vector.
}
\description{
Using some fairly unsophisticated metrics, \code{\link[=reindent]{reindent()}} will take some lines
of code and, according to its understanding of the rules for that language,
reindent those lines. This is intended to help prettify automatically
generated code.

This function is experimental.
}
\details{
Conceptually, the function first ignores any comments or string literals.
Then, line by line, \code{reindent} looks for tokens that signal either an
increase in the indent level, a decrease in the indent level, or both at
the same time. For example, in this Lua code:

\if{html}{\out{<div class="sourceCode">}}\preformatted{if x == 1 then
    print 'one'
else
    print 'not one'
end
}\if{html}{\out{</div>}}

the \code{if} keyword increases the indent level, the \verb{else} keyword both
decreases and increases the indent level, and the \code{end} keyword decreases
the indent level.

If provided, the \code{ignore} element of \code{rules} should be a list of character
vectors. A character vector of length one is assumed to start a comment that
runs to the end of the line (e.g. \code{"#"} in R). If length two, the two
symbols are assumed to start and end a comment or string (e.g. \code{"/*"} and
\code{"*/"} in C). If length three, then the first two symbols are start and end
delimiters of a comment or string, while the third symbol is an "escape"
character that escapes the end delimiter (and can also escape itself). This
is typically a backslash.

\code{\link[=reindent]{reindent()}} supports "raw strings" in R, C, C++, and Lua code but only in
limited cases. In R, when using \link[=Quotes]{raw character constants} you must
use an uppercase \code{R}, the double quote symbol and zero to two hyphens. In
C/C++, when using
\href{https://en.cppreference.com/w/cpp/language/string_literal.html}{raw string literals}
you must use the prefix \code{R}, and zero to two hyphens as the delimiter char
sequence (plus parentheses). In Lua, you can use
\href{https://www.lua.org/manual/5.2/manual.html#3.1}{long brackets} with zero
to two equals signs. Any other attempt to use raw strings will probably
break \code{\link[=reindent]{reindent()}}.

Other unusual character sequences may also break \code{\link[=reindent]{reindent()}}.
}
\examples{
reindent(
    c(
        "if x == 1 then",
        "print 'one'",
        "else",
        "print 'not one'",
        "end"
    ),
    rules = "Lua")
}
