% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{elixir-expression}
\alias{elixir-expression}
\title{Expressions in \code{elixir}}
\description{
\code{elixir} is primarily a package for working with what it calls
"expressions", in the sense of any R object for which
\code{\link[rlang:is_expression]{rlang::is_expression()}} returns \code{TRUE}. This includes calls, like the
results of evaluating \code{quote(f(x))} or \code{quote(a:b)}, symbols like
\code{quote(z)}, and syntactic literals like \code{2.5}, \code{"hello"}, \code{NULL}, \code{FALSE},
and so on.

This is not to be confused with the built-in type \link[base:expression]{base::expression}, which
is essentially a special way of storing a vector of multiple "expressions".
\code{elixir} does not use this type; see \code{\link[=expr_list]{expr_list()}} instead.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{expr_list(number = \{ `.A:numeric` \} ? \{ `.A:integer` \},
    string = \{ `.A:character` \}, symbol = \{ `.A:name` \})
expr_match(\{ 1 * 2 \}, ~\{ .A * .B \})
expr_match(\{ 1 * 2 \}, \{ `.A:numeric` \})
expr_replace(\{ y = a*x^3 + b*x^2 + c*x^1 + d*x^0 \},
    \{ ..X ^ ..N \}, \{ pow(..X, ..N) \})
}\if{html}{\out{</div>}}
}

\section{Specifying expressions in \code{elixir}}{


The \code{elixir} package functions starting with \code{expr_} work with expressions.
These functions all accept a special (optional) syntax for specifying
expressions which involves the symbols \code{{}}, \verb{?}, and \code{~}, as well as the
rlang \link[rlang:injection-operator]{injection operator, !!} and
\link[rlang:splice-operator]{splice operator, !!!}).

With base R, if you want to store an expression such as \code{x + y} in a
variable or pass it to a function, you need to use \code{\link[base:substitute]{base::quote()}} or
\code{\link[rlang:expr]{rlang::expr()}}, but any Elixir \code{expr_} function will also accept an
"expression literal" wrapped in braces, \code{{}}.

So, for example, rather than

\code{translate(quote(x ^ y), "C++")}

you can write

\code{translate({ x ^ y }, "C++")}.

This only works if the braces are provided "directly"; that is, in

\verb{expr <- quote(\{ x ^ y \}); translate(expr, "C++")},

the braces are not interpreted in any special way.

Anything between the braces essentially gets put through \code{\link[rlang:expr]{rlang::expr()}}, so
you can use \verb{!!} (i.e. \link[rlang:injection-operator]{rlang::injection-operator}) and \verb{!!!} (i.e.
\link[rlang:splice-operator]{rlang::splice-operator}). There is an \code{env} parameter to all relevant
\code{elixir} functions, defaulting to \code{parent.frame()}, in which these injection
operations are evaluated.
}

\section{Special syntax for patterns and replacements}{


Additionally, some functions (\code{\link[=expr_match]{expr_match()}}, \code{\link[=expr_count]{expr_count()}},
\code{\link[=expr_detect]{expr_detect()}}, \code{\link[=expr_extract]{expr_extract()}}, \code{\link[=expr_locate]{expr_locate()}}, and \code{\link[=expr_replace]{expr_replace()}})
take \code{pattern} and/or \code{replacement} arguments to specify patterns to match
to an expression and/or replacement expressions to replace those matches
with.

For both \code{pattern} and \code{replacement} arguments, you can use the question
mark operator \verb{?} to specify \emph{alternatives}. For example, to match \emph{either}
the token \code{cat} or \code{dog}, you can use

\code{expr_match(expr, { cat } ? { dog })}.

You can chain together as many alternatives as are needed. Alternatively,
if you have a list of expressions \code{z}, you can use a single question mark
before the name of the list, like so:

\code{expr_match(expr, ?z)}

and \code{elixir} will treat the list as a set of alternatives. When using
\code{\link[=expr_replace]{expr_replace()}} with a set of alternatives as the pattern, the replacement
needs to be either a single expression, or a set of alternative expressions
which has the same number of alternatives as in the pattern.

You can also use the tilde operator \code{~} to specify that a given pattern
should be "anchored" at the top level of an expression, and will not
"recurse into" the expression. For example, in

\if{html}{\out{<div class="sourceCode">}}\preformatted{exprs = expr_list(2, 5, \{1 + 4\})
expr_match(exprs, ~\{ `.A:numeric` \})
}\if{html}{\out{</div>}}

only the numbers \code{2} and \code{5} will match. However, in

\if{html}{\out{<div class="sourceCode">}}\preformatted{exprs = expr_list(2, 5, \{1 + 4\})
expr_match(exprs, \{ `.A:numeric` \})
}\if{html}{\out{</div>}}

all numbers \code{2}, \code{5}, \code{1} and \code{4} will match, because the \code{pattern} can
recurse into the third expression \code{1 + 4}.
}

