% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fable.R
\name{filter_esn}
\alias{filter_esn}
\title{Filter ESN models}
\usage{
filter_esn(object)
}
\arguments{
\item{object}{An object of class \code{mdl_df}, containing an ESN model.}
}
\value{
An object of class \code{mdl_df} in long-format.
}
\description{
Filter an object of class \code{mdl_df} ("mable") to include 
  ESN models only, i.e., other models like ARIMA or ETS are excluded from
  the mable.
}
\examples{
library(tsibble)
library(fable)
AirPassengers \%>\%
as_tsibble() \%>\%
model("ESN" = ESN(value)) \%>\%
filter_esn()

}
