% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct-rd.R, R/distinct.R
\name{distinct.duckplyr_df}
\alias{distinct.duckplyr_df}
\title{Keep distinct/unique rows}
\usage{
\method{distinct}{duckplyr_df}(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Optional variables to
use when determining uniqueness. If there are multiple rows for a given
combination of inputs, only the first row will be preserved. If omitted,
will use all variables in the data frame.}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.data}.
If a combination of \code{...} is not distinct, this keeps the
first row of values.}
}
\description{
This is a method for the \code{\link[dplyr:distinct]{dplyr::distinct()}} generic.
Keep only unique/distinct rows from a data frame.
This is similar to \code{unique.data.frame()} but considerably faster.
}
\examples{
df <- duckdb_tibble(
  x = sample(10, 100, rep = TRUE),
  y = sample(10, 100, rep = TRUE)
)
nrow(df)
nrow(distinct(df))
}
\seealso{
\code{\link[dplyr:distinct]{dplyr::distinct()}}
}
