% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onemode_Constraint_deprecatedV100.R
\name{computeBurtsConstraint}
\alias{computeBurtsConstraint}
\title{Compute Burt's (1992) Constraint for Ego Networks from a Sociomatrix}
\usage{
computeBurtsConstraint(
  net,
  inParallel = FALSE,
  nCores = NULL,
  isolates = NA,
  pendants = 1
)
}
\arguments{
\item{net}{A one-mode sociomatrix with network ties.}

\item{inParallel}{TRUE/FALSE. TRUE indicates that parallel processing will be used to compute the statistic with the \emph{foreach} package. FALSE indicates that parallel processing will not be used. Set to FALSE by default.}

\item{nCores}{If inParallel = TRUE, the number of computing cores for parallel processing. If this value is not specified, then the function internally provides it by dividing the number of available cores in half.}

\item{isolates}{What value should isolates be given? Set to NA by default.}

\item{pendants}{What value should be given to pendant vertices? Pendant vertices are those nodes who have one outgoing tie. Set to 1 by default.}
}
\value{
The vector of ego network constraint values.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{computeBurtsConstraint()} has been deprecated starting on version 1.0.0 of the \code{dream} package. Please use the \code{netstats_om_constraint()} function and see the \code{NEWS.md} file for more details.

This function computes Burt's (1992) one-mode ego constraint based upon a sociomatrix.
}
\details{
The formula for Burt's (1992) one-mode ego constraint is:
\deqn{c_{ij} = \left(p_{ij} + \sum_{q} p_{iq} p_{qj}\right)^2 \quad ; \; q \neq i \neq j}
where:
\itemize{
\item \eqn{p_{iq}} is formulated as: \eqn{p_{iq} = \frac{z_{iq} + z_{qi}}{\sum_{j}(z_{ij} + z_{ji})} \quad ; \; i \neq j}
}
Finally, the aggregate constraint of an ego \emph{i} is:
\deqn{C_{i} = \sum_{j} c_{ij}}
While this function internally locates isolates (i.e., nodes
who have no ties) and pendants, that is, nodes who only have
one outgoing tie, the user should specify what values for constraint are returned for them via the \emph{isolates} and
\emph{pendants} options.

Lastly, this function allows users to compute the values in parallel via the
\emph{foreach}, \emph{doParallel}, and \emph{parallel} R packages.
}
\examples{

# For this example, we recreate the ego network provided in Burt (1992: 56):
BurtEgoNet <- matrix(c(
  0,1,0,0,1,1,1,
 1,0,0,1,0,0,1,
 0,0,0,0,0,0,1,
 0,1,0,0,0,0,1,
 1,0,0,0,0,0,1,
 1,0,0,0,0,0,1,
 1,1,1,1,1,1,0),
 nrow = 7, ncol = 7)
colnames(BurtEgoNet) <- rownames(BurtEgoNet) <- c("A", "B", "C", "D", "E",
                                                 "F", "ego")
#the constraint value for the ego replicates that provided in Burt (1992: 56)
computeBurtsConstraint(BurtEgoNet)


}
\references{
Burt, Ronald. 1992. \emph{Structural Holes: The Social Structure of Competition}.
Harvard University Press.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
