% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDynamics.R
\name{plotDynamics}
\alias{plotDynamics}
\title{Plot barcode dynamics}
\usage{
plotDynamics(
  reshaped_df,
  colored_topFreq_df,
  min_freq_threshold,
  plot_model,
  output_directory,
  input_name
)
}
\arguments{
\item{reshaped_df}{A dataframe produced by \code{reshapeData()}, containing barcode frequencies over time.}

\item{colored_topFreq_df}{A dataframe with top barcodes and their assigned color hex codes and max frequencies.}

\item{min_freq_threshold}{A numeric threshold; barcodes with max frequency below this are colored gray.}

\item{plot_model}{One of \code{"linear"}, \code{"logarithmic"}, or \code{"both"} to specify the plot type(s).}

\item{output_directory}{A string specifying the directory where plots will be saved.}

\item{input_name}{A string used as the base name for output files (e.g., "replicate1").}
}
\value{
No return value. Depending on the \code{plot_model} parameter:
\itemize{
\item Saves a linear-scale area plot (\verb{_area.jpg}) showing the dynamics of barcode frequencies over time.
\item Saves a logarithmic-scale line plot (\verb{_line.eps}) highlighting prominent barcodes across time.
}
}
\description{
This function plots the dynamics of barcode frequencies over time, using either linear-scale
area plots, logarithmic-scale line plots, or both. Only the most frequent barcodes are colored.
}
\examples{
\donttest{
# Load demo barcode count data
demo_file <- system.file("extdata", "demo_input.csv", package = "doblin")
input_dataframe <- readr::read_csv(demo_file, show_col_types = FALSE)

# Reshape and extract top lineages
reshaped_df <- reshapeData(input_dataframe)
top_barcodes <- fetchTop(reshaped_df, N_LINEAGES = 10)

# Load color list and assign hex codes
color_file <- system.file("extdata", "top_colors2.csv", package = "doblin")
color_df <- readr::read_csv(color_file, show_col_types = FALSE)
color_df <- color_df[1:nrow(top_barcodes), ]
colored_top <- cbind(top_barcodes, color_df)

# Plot dynamics
plotDynamics(
  reshaped_df = reshaped_df,
  colored_topFreq_df = colored_top,
  min_freq_threshold = 0.001,
  plot_model = "both",
  output_directory = tempdir(),
  input_name = "demo"
)
}
}
