% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{coldwell_2006}
\alias{coldwell_2006}
\title{Coldwell, Pike and Dunn (2006) data}
\format{
A tibble with 118 rows and 9 variables.
}
\source{
\href{https://www.discovr.rocks/csv/coldwell_2006.csv}{www.discovr.rocks/csv/coldwell_2006.csv}
}
\usage{
coldwell_2006
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Coldwell, Pike and Dunn (2006) investigated whether household chaos predicted children's problem behaviour
over and above parenting. From 118 families they recorded the age and gender of the youngest child
(\strong{child_age} and \strong{child_gender}). They measured dimensions of the child's perceived relationship with
their mum: (1) warmth/enjoyment (\strong{child_warmth}), and (2) anger/hostility (\strong{child_anger}). Higher scores
indicate more warmth/enjoyment and anger/hostility respectively. They measured the mum's perceived relationship
with her child, resulting in dimensions of positivity (\strong{mum_pos}) and negativity (\strong{mum_neg}).
Household chaos (\strong{chaos}) was assessed. The outcome variable was the child's adjustment (\strong{sdq}): the higher the score,
the more problem behaviour the child was reported to be displaying. These data are from this study. The data contain the following variables:
\itemize{
\item \strong{family_id}: The family id
\item \strong{child_age}: Age of the youngest child
\item \strong{child_gender}: Gender of the youngest child
\item \strong{child_warmth}: Perceived warmth of the child to the mother.
\item \strong{child_anger}: Perceived anger of the child towards to the mother.
\item \strong{mum_pos}: the mother's perceived positivity towards her child.
\item \strong{mum_neg}: the mother's perceived negativity towards her child.
\item \strong{chaos}: household chaos.
\item \strong{sdq}: the child's adjustment on the strengths and difficulties questionnaire (SDQ).
}
}
\keyword{datasets}
