% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{variogram}
\alias{variogram}
\title{Plot the variogram for a fitted \code{deform} object}
\usage{
variogram(object, bins = 20, bin.function = "pretty", trim = 0, ...)
}
\arguments{
\item{object}{a fitted \code{deform} object}

\item{bins}{an integer specifying the number of bins for plotting}

\item{bin.function}{a character specifying a function to use to calculate bins; defaults to \code{pretty()}}

\item{trim}{a scalar in [0, 0.5], which is passed to \code{mean()} when calculating binned variogram estimates; defaults to 0}

\item{...}{extra arguments to pass to \code{plot()}}
}
\value{
Plot of variogram
}
\description{
Plot the variogram for a fitted \code{deform} object
}
\examples{

\donttest{

# deformations
data(solar)
m0 <- deform(solar$x, solar$z, solar$n)

# empirical versus model-based variogram estimates against distance,
# where distance is based on D-space
variogram(m0)
# which is the default with approximately 20 bins, i.e. variogram(m0, bins = 20)

}

# variogram for one-dimensional expansion without binning
data(solar)
m1 <- expand(solar$x, solar$z, solar$n)
variogram(m1, bins = 0)

}
