% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFF.R
\name{AFF_2D}
\alias{AFF_2D}
\title{Affine transformation on a 2D domain}
\usage{
AFF_2D(a = c(0, 1, 0, 0, 0, 1), dtype = "float32")
}
\arguments{
\item{a}{vector of six real numbers describing an affine transformation on a 2D domain}

\item{dtype}{data type}
}
\value{
\code{AFF_2D} returns a list containing a list with the following components:
\describe{
 \item{"f"}{An encapsulated function that takes an input and evaluates the affine transformation using \code{TensorFlow}}
 \item{"fR"}{Same as \code{f} but uses \code{R}}
 \item{"r"}{The number of basis functions (fixed to 1 in this case)}
 \item{"trans"}{The transformation applied to the weights before estimation (in this case the identity)}
 \item{"fix_weights"}{Flag indicating whether the weights are fixed or not (TRUE in this case)}
 \item{"name"}{Name of layer}
 \item{"pars"}{List of parameters describing the affine transformation as \code{TensorFlow} objects}
}
}
\description{
Sets up an affine transformation on a 2D domain
}
