% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status_check.R
\name{status_check}
\alias{status_check}
\title{Check that all DAWA services are operational}
\usage{
status_check(return_df = FALSE, error_if_unavailable = FALSE)
}
\arguments{
\item{return_df}{This option makes the function return a data.frame object
with the services and their statuses listed}

\item{error_if_unavailable}{This option forces the function to throw an error
in the event that one or more services are unreachable.}
}
\value{
Returns a data frame object with the services and their statuses. Is
only returned if \code{return_df = TRUE}.
}
\description{
This function fetches the status of all available SDFI services.
This package depends on at least one of these. It checks the official
status page. The status can also be followed on their official X-page
\verb{@DriftDataforsyn}.
}
\note{
Please note that the status at the status page is only checked at
regular intervals. If you would like to know if your machine can access the
serviceses, please try \code{connection_check()} as well.
}
\examples{
if (connection_check()) {
  status_check()

  status_check(return_df = TRUE)
}
}
\seealso{
Other Connection checks: 
\code{\link{connection_check}()}
}
\concept{Connection checks}
