% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_metric_data}
\alias{cvd_indicator_metric_data}
\title{Metric data}
\usage{
cvd_indicator_metric_data(metric_id = 7, time_period_id = 1, area_id = 2)
}
\arguments{
\item{metric_id}{integer - metric for which to return data for (compulsory)}

\item{time_period_id}{integer - time period for which to return data for (compulsory)}

\item{area_id}{integer - area for which to return data for (compulsory)}
}
\value{
Tibble of details for metric performance in the area and time period
}
\description{
Returns all metric data for a specified metric. Data will include values
for both selected area and organisation at National Level (usually England).
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#*Proposed*\%2Findicator\%2Fmetric\%2F\%3Cmetric_id\%3E\%2Fdata}{Indicator metric data}
}
\examples{
# Retrieve metric data for AF: treatment with anticoagulants for 'Alliance
# PCN' (area ID 399) in time period 1 for metric 126 (breakdown by age group:
# males aged 40-59):
cvd_indicator_metric_data(metric_id = 126, time_period_id = 1, area_id = 399) |>
  dplyr::select(IndicatorShortName, CategoryAttribute, MetricCategoryName,
  AreaData.Value, NationalData.Value)
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
