% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccor_posim.R
\name{ccor_posim}
\alias{ccor_posim}
\title{Credible interval estimation for curve correlation based on posterior simulation}
\usage{
ccor_posim(
  y,
  time,
  curve = NULL,
  method,
  k = 15,
  conf = 0.95,
  ndraw = 999,
  min.overlap = 0
)
}
\arguments{
\item{y, time, curve, k, min.overlap}{see \code{\link{ccor}}}

\item{method}{\code{"indep"} (curves fitted independently)
or \code{"mvn"} (curves fitted together, with error correlation estimated based on multivariate normal likelihood)}

\item{conf}{confidence level}

\item{ndraw}{number of draws from posterior distribution of spline coefficient vector}
}
\value{
A list with components
\item{cor }{curve correlation}
\item{model }{the model for the two curves (if \code{method=="mvn"}), or a list of the two curves' models  (if \code{method=="indep"})}
\item{bsb }{B-spline basis (from package \code{fda}) used for the curves}
\item{Vc.fda }{corrected posterior covariance matrix for the coefficients with respect to the B-spline basis \code{bsb}
(see the component \code{$Vc} in \code{\link[mgcv]{gamObject}})}
\item{sims }{curve correlations for the \code{ndraw} draws from the posterior distribution}
\item{ci }{credible interval for the curve correlation}
}
\description{
Inputs raw data representing two curves, and computes a credible interval
for the curve correlation between them simulating from the approximate posterior
distribution of the joint spline coefficient vector.
}
\examples{

## Not run:
if (interactive () &&
    requireNamespace("wbwdi", quietly = TRUE) &&
    requireNamespace("ggplot2", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {

    # Curve correlation of per capita GDP and fertility rate in Paraguay
    wdi_dat <- wbwdi::wdi_get(entities = c("PRY"), start_year=1960, end_year=2023,
                       indicators = c("NY.GDP.PCAP.KD","SP.DYN.TFRT.IN"), format="wide") |>
        dplyr::rename(percapitaGDP = NY.GDP.PCAP.KD, fertility = SP.DYN.TFRT.IN)
    ggplot2::ggplot(wdi_dat, aes(percapitaGDP, fertility, color=year)) + geom_point()

    y <- as.matrix(wdi_dat[ , c("percapitaGDP", "fertility")])

    set.seed(345)

    ci <- list()
    ci[[1]] <- ccor_posim(y=y, time=wdi_dat$year, method="indep")
    ci[[2]] <- ccor_posim(y=y, time=wdi_dat$year, method="mvn")
    ci[[3]] <- ccor_boot(y=y, time=wdi_dat$year, ndraw=399)

    tabl <- matrix(NA, 3, 3)
    for (k in 1:3) tabl[k, ] <- c(ci[[k]]$cor, ci[[k]]$ci)
    dimnames(tabl) <- list(c("Posim_indep", "Posim_MVN", "Bootstrap"), c("Est","Lower95","Upper95"))
    round(tabl, 4)
}
## End(Not run)

}
\seealso{
\code{\link{ccor}}, \code{\link{ccor_boot}}, \code{\link[mgcv]{mvn}}
}
\author{
Philip Tzvi Reiss <reiss@stat.haifa.ac.il>, Noemi Foa, Dror Arbiv and Biplab Paul <paul.biplab497@gmail.com>
}
