% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-methods.R
\name{update,DataOrdinal-method}
\alias{update,DataOrdinal-method}
\alias{update-DataOrdinal}
\title{Updating \code{DataOrdinal} Objects}
\usage{
\S4method{update}{DataOrdinal}(
  object,
  x,
  y,
  ID = length(object@ID) + seq_along(y),
  new_cohort = TRUE,
  check = TRUE,
  ...
)
}
\arguments{
\item{object}{(\code{DataOrdinal})\cr object you want to update.}

\item{x}{(\code{number})\cr the dose level (one level only!).}

\item{y}{(\code{integer})\cr the vector of toxicity grades (0, 1, 2, ...) for all
patients in this cohort. You can also supply \code{numeric} vectors, but these
will then be converted to \code{integer} internally.}

\item{ID}{(\code{integer})\cr the patient IDs.
You can also supply \code{numeric} vectors, but these will then be converted to
\code{integer} internally.}

\item{new_cohort}{(\code{flag})\cr if \code{TRUE} (default) the new data are assigned
to a new cohort.}

\item{check}{(\code{flag})\cr whether the validation of the updated object should
be conducted. See Details below.}

\item{...}{not used.}
}
\value{
The new, updated \code{\link{DataOrdinal}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A method that updates existing \code{\link{DataOrdinal}} object with new data.
}
\details{
The current implementation of this \code{update} method allows for
updating the \code{DataOrdinal} class object by adding a single dose level \code{x} only.
However, there might be some use cases where the new cohort to be added
contains a placebo and active dose. Hence, such update would need to be
performed iteratively by calling the \code{update} method twice. For example,
in the first call a user can add a placebo, and then in the second call,
an active dose. Since having a cohort with placebo only is not allowed,
the \code{update} method would normally throw the error when attempting to add
a placebo in the first call. To allow for such updates, the \code{check}
parameter should be then set to \code{FALSE} for that first call.
}
\examples{
data <- DataOrdinal(
  x = c(10, 20, 30, 40, 50, 50, 50, 60, 60, 60),
  y = as.integer(c(0, 0, 0, 0, 0, 1, 0, 0, 1, 2)),
  ID = 1L:10L,
  cohort = as.integer(c(1:4, 5, 5, 5, 6, 6, 6)),
  doseGrid = c(seq(from = 10, to = 100, by = 10)),
  yCategories = c("No tox" = 0L, "Sub-tox AE" = 1L, "DLT" = 2L),
  placebo = FALSE
)

update(data, x = 70, y = c(1L, 2L, 1L))
}
