% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve.R
\name{lap_solve_line_metric}
\alias{lap_solve_line_metric}
\title{Solve 1-D Line Assignment Problem}
\usage{
lap_solve_line_metric(x, y, cost = "L1", maximize = FALSE)
}
\arguments{
\item{x}{Numeric vector of source positions (will be sorted internally)}

\item{y}{Numeric vector of target positions (will be sorted internally)}

\item{cost}{Cost function for distance. Either:
\itemize{
\item "L1" (default): absolute distance ('Manhattan' distance)
\item "L2": squared distance (squared 'Euclidean' distance)
Can also use aliases: "abs", "manhattan" for L1; "sq", "squared", "quadratic" for L2
}}

\item{maximize}{Logical; if TRUE, maximizes total cost instead of minimizing (default: FALSE)}
}
\value{
A list with components:
\itemize{
\item \code{match}: Integer vector of length n with 1-based column indices
\item \code{total_cost}: Total cost of the assignment
}
}
\description{
Solves the linear assignment problem when both sources and targets are
ordered points on a line. Uses efficient O(n*m) dynamic programming
for rectangular problems and O(n) sorting for square problems.
}
\details{
This is a specialized solver that exploits the structure of 1-dimensional
assignment problems where costs depend only on the distance between points
on a line. It is much faster than general LAP solvers for this special case.

The algorithm works as follows:

\strong{Square case (n == m):}
Both vectors are sorted and matched in order: \code{x[1] -> y[1]}, \code{x[2] -> y[2]}, etc.
This is optimal for any metric cost function on a line.

\strong{Rectangular case (n < m):}
Uses dynamic programming to find the optimal assignment that matches all n sources
to a subset of the m targets, minimizing total distance. The DP recurrence is:

\code{dp[i][j] = min(dp[i][j-1], dp[i-1][j-1] + cost(x[i], y[j]))}

This finds the minimum cost to match the first i sources to the first j targets.

\strong{Complexity:}
\itemize{
\item Time: O(n*m) for rectangular, O(n log n) for square
\item Space: O(n*m) for DP table
}
}
\examples{
# Square case: equal number of sources and targets
x <- c(1.5, 3.2, 5.1)
y <- c(2.0, 3.0, 5.5)
result <- lap_solve_line_metric(x, y, cost = "L1")
print(result)

# Rectangular case: more targets than sources
x <- c(1.0, 3.0, 5.0)
y <- c(0.5, 2.0, 3.5, 4.5, 6.0)
result <- lap_solve_line_metric(x, y, cost = "L2")
print(result)

# With unsorted inputs (will be sorted internally)
x <- c(5.0, 1.0, 3.0)
y <- c(4.5, 0.5, 6.0, 2.0, 3.5)
result <- lap_solve_line_metric(x, y, cost = "L1")
print(result)

}
