% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.R
\name{identify_response_type}
\alias{identify_response_type}
\title{Identify Response Type}
\usage{
identify_response_type(df = NULL, response = NULL, quiet = FALSE)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional; character string or vector) Name/s of response variable/s in \code{df}. Used in target encoding when it names a numeric variable and there are categorical predictors, and to compute preference order. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
character string: response type
}
\description{
Internal function to identify the type of response variable. Supported types are:
\itemize{
\item "continuous-binary": decimal numbers and two unique values; results in a warning, as this type is difficult to model.
\item "continuous-low": decimal numbers and 3 to 5 unique values; results in a message, as this type is difficult to model.
\item "continuous-high": decimal numbers and more than 5 unique values.
\item "integer-binomial": integer with 0s and 1s, suitable for binomial models.
\item "integer-binary": integer with 2 unique values other than 0 and 1; returns a warning, as this type is difficult to model.
\item "integer-low": integer with 3 to 5 unique values or meets specified thresholds.
\item "integer-high": integer with more than 5 unique values suitable for count modelling.
\item "categorical": character or factor with 2 or more levels.
\item "unknown": when the response type cannot be determined.
}
}
\examples{
identify_response_type(
  df = vi,
  response = "vi_numeric"
)

identify_response_type(
  df = vi,
  response = "vi_counts"
)

identify_response_type(
  df = vi,
  response = "vi_binomial"
)

identify_response_type(
  df = vi,
  response = "vi_categorical"
)

identify_response_type(
  df = vi,
  response = "vi_factor"
)

}
\seealso{
Other data_types: 
\code{\link{identify_predictors}()},
\code{\link{identify_predictors_categorical}()},
\code{\link{identify_predictors_numeric}()},
\code{\link{identify_predictors_type}()},
\code{\link{identify_predictors_zero_variance}()}
}
\concept{data_types}
