% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfa.R
\name{TFA}
\alias{TFA}
\title{Transfer function analysis of dynamic cerebral autoregulation (TFA)}
\usage{
TFA(df, variables,
trigger = NULL, deleter = NULL,
freq = 1000, fast = 50, raw_data = FALSE,
interpolation = 3, output = "table",
vlf = c(0.02,0.07),lf = c(0.07,0.2),
hf = c(0.2,0.5), detrend = FALSE,
spectral_smoothing = 3,
coherence2_thresholds = cbind(c(3:15),
c(0.51,0.40,0.34,0.29,0.25,0.22,0.20,0.18,
0.17,0.15,0.14,0.13,0.12)),
apply_coherence2_threshold = TRUE,
remove_negative_phase = TRUE,
remove_negative_phase_f_cutoff = 0.1,
normalize_ABP = FALSE,
normalize_CBFV = FALSE,
window_type = 'hanning',
window_length = 102.4,
overlap = 59.99,
overlap_adjust = TRUE,
na_as_mean = TRUE)
}
\arguments{
\item{df}{Raw \emph{continuous} recording with numeric data and first column has to be time in seconds. (\code{dataframe})}

\item{variables}{Definition of the type and order of recorded variables as a list. Middle cerebral artery blood velocity (\code{'mcav'}) and arterial blood pressure (\code{'abp'}) is currently supported. (\code{list})}

\item{trigger}{Trigger with two columns:  first is start, and second is end of period to be analyzed. Every row is a period for analysis. Default is \code{NULL}, which results in analysis of the full dataframe.  (\code{dataframe})}

\item{deleter}{Deleter with two columns: first is start and second is end of period with artefacts, which need to be deleted. Every row is a period with artefacts. Default is \code{NULL}. (\code{dataframe})}

\item{freq}{Frequency of recorded data, in Hz. Default is \code{1000}. (\code{numeric})}

\item{fast}{Select if you want the data to aggregated resulting in a faster, but perhaps more imprecise run, in Hz. Default is \code{50} (\code{numeric})}

\item{raw_data}{Select \code{TRUE} if the data is raw and cyclic mean should be calculated. \strong{NB:} this function have not been validated, why validated methods for calculating cyclic mean are preferred. Default is \code{FALSE} (\code{boolian})}

\item{interpolation}{Select the number of beats which should be interpolated. Default is up to \code{3} beats and \code{0} results in no interpolation. (\code{numeric})}

\item{output}{Select what the output should be. \code{'table'} results in a dataframe with values for the three frequencies defined by Claassen et al. [1]; \code{'long'} results in a dataframe with the results in a long format; \code{'plot'} results in a daframe which can help plot gain, phase and coherence; \code{'plot-peak'} results in a dataframe, which can be used to validate the cyclic average, and \code{'raw'} results in a nested list with results primarily for debugging. Default is \code{'table'}. (\code{string})}

\item{vlf, lf, hf, detrend, spectral_smoothing, coherence2_thresholds}{See \strong{TFA-parameters}}

\item{apply_coherence2_threshold, remove_negative_phase}{See \strong{TFA-parameters}}

\item{remove_negative_phase_f_cutoff, normalize_ABP}{See \strong{TFA-parameters}}

\item{normalize_CBFV, window_type, window_length, overlap}{See \strong{TFA-parameters}}

\item{overlap_adjust, na_as_mean}{See \strong{TFA-parameters}}
}
\value{
\code{TFA()} returns a dataframe depending on the output selected. \code{'table'} results in a dataframe with values for the three frequencies defined by Claassen et al. [1]; \code{'long'} results in a dataframe with the results in a long format; \code{'plot'} results in a daframe which can help plot gain, phase and coherence; \code{'plot-peak'} results in a dataframe, which can be used to validate the cyclic average, and \code{'raw'} results in a nested list with results primarily for debugging.

Some generic variables are listed below:
\itemize{
\item \code{abp_power} - The blood pressure power measured in mmHg^2.
\item \code{cbfv_power} - The cerebral blood flow velocity power measured in cm^2\*s^-2
\item \code{coherence} - Coherence.
\item \code{gain_not_normal} - Not normalized gain measured in cm\*s^-1\*mmHg^-1.
\item \code{gain_normal} - Normalized gain measured in \%\*mmHg^-1.
\item \code{phase} - Phase measured in radians.
}
\subsection{output = 'table'}{

Wide format output table with period, VLF, LF, and HF as columns, and the TFA-variables as rows.\tabular{lrrrr}{
   \code{period} \tab \code{variable} \tab \code{vlf} \tab \code{lf} \tab \code{hf} \cr
   \code{1} \tab \code{abp_power} \tab \code{6.25} \tab \code{1.56} \tab \code{0.21} \cr
   \code{1} \tab \code{cbfv_power} \tab \code{3.22} \tab \code{2.25} \tab \code{0.30} \cr
   \code{...} \tab \code{...} \tab \code{...} \tab \code{...} \tab \code{...} \cr
   \code{3} \tab \code{gain_normal} \tab \code{1.04} \tab \code{1.48} \tab \code{1.85} \cr
   \code{3} \tab \code{phase} \tab \code{53.0} \tab \code{25.4} \tab \code{9.38} \cr
}

}

\subsection{output = 'long'}{

Long format output table which can be manipulated depending on the intended use, with period, interval, variables and values as columns.\tabular{rllr}{
   \code{period} \tab \code{interval} \tab \code{variable} \tab \code{values} \cr
   \code{1} \tab \code{hf} \tab \code{abp_power} \tab \code{6.25} \cr
   \code{1} \tab \code{hf} \tab \code{cbfv_power} \tab \code{3.22} \cr
   \code{...} \tab \code{...} \tab \code{...} \tab \code{...} \cr
   \code{2} \tab \code{vlf} \tab \code{gain_norm} \tab \code{1.85} \cr
   \code{2} \tab \code{vlf} \tab \code{phase} \tab \code{9.38} \cr
}

}

\subsection{output = 'plot'}{

Plot format output table which can be used to draw figures with gain, phase and coherence depending on frequency.\tabular{rrrrr}{
   \code{period} \tab \code{freq} \tab \code{gain} \tab \code{phase} \tab \code{coherence} \cr
   \code{1} \tab \code{0.00} \tab \code{0.16} \tab \code{0.00} \tab \code{0.04} \cr
   \code{1} \tab \code{0.01} \tab \code{0.29} \tab \code{4.22} \tab \code{0.29} \cr
   \code{...} \tab \code{...} \tab \code{...} \tab \code{...} \tab \code{...} \cr
   \code{2} \tab \code{1.55} \tab \code{1.15} \tab \code{-43.2} \tab \code{0.64} \cr
   \code{2} \tab \code{1.56} \tab \code{1.16} \tab \code{-41.1} \tab \code{0.42} \cr
}

}
}
\description{
\code{TFA()} calculates dynamic cerebral autoregulation trough a transfer function analysis from a \emph{continuous} recording. This function follows the recommendations from Claassen et al. [1] and mimicks the matlab script created by David Simpsons in 2015 (\href{http://www.car-net.org/content/resources#tabTools}{Matlab TFA function}). \code{TFA()} also includes the possibility to analyse raw recordings with application of cyclic (beat-to-beat) average with the possiblity of utilizing interpolation. (see \strong{details}).
}
\details{
Using a \emph{continuous} raw recording, \code{TFA()} calculates dynamic cerebral autoregulation trough a transfer function analysis. This function utilizes the recommendations from Claassen et al [1] and mimicks the matlab script created by David Simpsons in 2015.\preformatted{View(data)
}\tabular{rrr}{
   \code{time} \tab \code{abp} \tab \code{mcav} \cr
   \code{7.00} \tab \code{78} \tab \code{45} \cr
   \code{7.01} \tab \code{78} \tab \code{46} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{301.82} \tab \code{82} \tab \code{70} \cr
   \code{301.83} \tab \code{81} \tab \code{69} \cr
}


To calculate the variables insert the data and select the relevant variables.\preformatted{TFA(df=data, variables=c("abp","mcav"))
}

See \strong{Value} for output description.
}
\section{TFA-paramters}{

A series of parameters that control TFA analysis (window-length, frequency bands …). If this is not provided, default values, corresponding to those recommended in the white paper, will be used. These default values are given below for each parameter.
\itemize{
\item \code{vlf} Limits of \emph{very low frequency} band (in Hz). This corresponds to the matematical inclusion of \verb{[X:Y[}. Default is \code{c(0.02-0.07)}.
\item \code{lf} Limits of \emph{low frequency} band (in Hz). This corresponds to the matematical inclusion of \verb{[X:Y[}. Default is \code{c(0.07-0.2)}.
\item \code{hf} Limits of \emph{high frequency} band (in Hz). This corresponds to the matematical inclusion of \verb{[X:Y[}. Default is \code{c(0.2-0.5)}.
\item \code{detrend} Linear detrending of data prior to TFA-analysis (detrending is carried out as one continuous trend over the whole length of the recording, not segment-by-segment). Default is \code{FALSE}.
\item \code{spectral_smoothing} The length, in samples, of the triangular spectral smoothing function. Note that this must be an odd number, to ensure that smoothing is symmetrical around the centre frequency. Default is \code{3}.
\item \code{coherence2_thresholds} The critical values (alpha=5\%, second column) for coherence for a number of windows (first column, here from 3 to 15). These values were obtained by Monte Carlo simulation, using the default parameter settings for the TFA-analysis (Hanning window, overlap of 50\% and 3-point spectral smoothing was assumed). These values should be recalculated for different settings. Note that if \code{overlap_adjust=TRUE}, the overlap will vary depending on the length of data. With an overlap of 60\% (see below), the critical values increase by between 0.04 (for 3 windows) and 0.02 (for 15 windows). Default is \verb{cbind(c(3:15),c(0.51,0.40,} \verb{0.34,0.29,0.25,0.22,0.20,0.18,0.17,} \verb{0.15,0.14,0.13,0.12))}.
\item \code{apply_coherence2_threshold} Apply the thresholds given above to the TFA-estimates. All frequencies with magnitude-squared coherence below the threshold value are excluded from averaging when calculating the mean values of gain and phase across the bands. Note that low values of coherence are not excluded in the average of coherence across the bands. Default is \code{TRUE}.
\item \code{remove_negative_phase} Remove (ignore) negative values of phase in averaging across bands. Negative phase values are removed only for frequencies below the frequency given below, when calculating the average phase in bands. Default is \code{TRUE}.
\item \code{remove_negative_phase_f_cutoff} The cut-off frequency below-which negative phase values are neglected (only if \code{remove_negative_phase} is \code{TRUE}). Default is \code{0.1}.
\item \code{normalize_ABP} Normalize ABP by dividing by the mean and multiplying by 100, to express ABP change in \%. Note that mean-values are always removed from ABP prior to analysis. Default is \code{FALSE}.
\item \code{normalize_CBFV} Normalize CBFV by dividing by the mean and multiplying by 100, to express CBFV change in \%. Note that the band-average values of gain are always calculated both with and without normalization of CBFV, in accordance with the recommendations. Note also that mean-values are always removed from CBFV prior to analysis. Default is \code{FALSE}.
\item \code{window_type} Chose window \code{'hanning'} or \code{'boxcar'}. Default is \code{'hanning'}.
\item \code{window_length} Length of the data-window, in seconds. Default is \code{102.4}.
\item \code{overlap} Overlap of the windows, in \%. If \code{overlap_adjust} is \code{TRUE} (see below), then this value may be automatically reduced, to ensure that windows cover the full length of data. Default is \verb{59.99\%} rather than 60\%, so that with data corresponding to 5 windows of 100 s at an overlap of 50\%, 5 windows are indeed chosen.
\item \code{overlap_adjust} Ensure that the full length of data is used (i.e. the last window finishes as near as possible to the end of the recording), by adjusting the overlap up to a maximum value given by params.overlap. Default is \code{TRUE}.
\item \code{na_as_mean} Changes all missing non-interpolated values to the mean value of the corresponding variable. This have not been adressed in the paper by Claassen, and to ensure the dataframes are not 'gathered' this should generate the most stable results. Default is \code{TRUE}.
}
}

\examples{
data(tfa_sample_data)
TFA(tfa_sample_data[,c(1:3)], variables=c("abp","mcav"), freq=10)

}
\references{
\enumerate{
\item Claassen et al. (2016) J Cereb Blood Flow Metab. 2016 Apr;36(4):665-80. (\href{https://pubmed.ncbi.nlm.nih.gov/26782760/}{PubMed})
}
}
