% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_cff_person.R
\name{as_cff_person}
\alias{as_cff_person}
\alias{as_cff_person.default}
\alias{as_cff_person.person}
\alias{as_cff_person.character}
\title{Coerce \strong{R} objects to \code{\link{cff_pers_lst}} objects (\code{cff} persons)}
\usage{
as_cff_person(x, ...)

\method{as_cff_person}{default}(x, ...)

\method{as_cff_person}{person}(x, ...)

\method{as_cff_person}{character}(x, ...)
}
\arguments{
\item{x}{Any \strong{R} object.}

\item{...}{Ignored by this method.}
}
\value{
\code{as_cff_person()} returns an object of classes
\code{\link[=cff_pers_lst]{cff_pers_lst, cff}} according to the \code{definitions.person}
or \code{definitions.entity} specified in the \href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Citation File Format schema}.
Each element of the \code{cff_pers_lst} object would have classes
\code{\link[=cff_pers]{cff_pers, cff}}.
}
\description{
\code{as_cff_person()} turns an existing list-like \strong{R} object into a
\code{\link{cff_pers_lst}} object representing a list of \code{definitions.person} or
\code{definitions.entity}, as defined by the \href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Citation File Format schema}.

\code{as_cff_person} is an S3 generic, with methods for:
\itemize{
\item \code{person}: objects created with \code{\link[=person]{person()}}.
\item \code{character}: String with the definition of an author or several authors,
using the standard BibTeX notation (see Markey, 2007) and others, like
the output of \code{\link[=format]{format()}} for person (see \code{\link[=person]{format.person()}}).
\item Default: Other inputs are first coerced with \code{\link[=as.character]{as.character()}}.
}

The inverse transformation (\code{cff_pers_lst} to \code{person}) can be done with
the methods \code{\link[=as.person.cff_pers]{as.person.cff_pers()}} and \code{\link[=as.person.cff_pers_lst]{as.person.cff_pers_lst()}}.
}
\details{
\code{as_cff_person()} would recognize if the input should be converted using the
CFF reference for \code{definition.person} or \code{definition.entity}.

\code{as_cff_person()} uses a custom algorithm that tries to break a name as
explained in Section 11 of "Tame the BeaST" (Markey, 2007) (see also
Decoret, 2007):
\itemize{
\item \verb{First von Last}.
\item \verb{von Last, First}.
\item \verb{von Last, Jr, First}.
}

Mapping is performed as follows:
\itemize{
\item \code{First} is mapped to the CFF field \code{given-names}.
\item \code{von} is mapped to the CFF field \code{name-particle}.
\item \code{Last} is mapped to the CFF field \code{family-names}.
\item \code{Jr} is mapped to the CFF field \code{name-suffix}.
}

In the case of entities, the whole \code{character} would be mapped to \code{name}.
It is a good practice to "protect" entity's names with \code{{}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Don't do
entity <- "Elephant and Castle"
as_cff_person(entity)
- name: Elephant
- name: Castle

# Do
entity_protect <- "\{Elephant and Castle\}"
as_cff_person(entity_protect)
- name: Elephant and Castle
}\if{html}{\out{</div>}}

\code{as_cff_person()} would try to add as many information as possible.
On \code{character} string coming from \code{\link[utils:person]{format.person()}} the
email and the ORCID would be retrieved as well.
}
\examples{
# Create a person object
a_person <- person(
  given = "First", family = "Author",
  role = c("aut", "cre"),
  email = "first.last@example.com", comment = c(
    ORCID = "0000-0001-8457-4658",
    affiliation = "An affiliation"
  )
)

a_person

cff_person <- as_cff_person(a_person)

# Class cff_pers_lst / cff
class(cff_person)

# With each element with class cff_pers / cff
class(cff_person[[1]])

# Print
cff_person

# Back to person object with S3 Method
as.person(cff_person)

# Coerce a string
a_str <- paste0(
  "Julio Iglesias <fake@email.com> ",
  "(<https://orcid.org/0000-0001-8457-4658>)"
)
as_cff_person(a_str)

# Several persons
persons <- c(
  person("Clark", "Kent", comment = c(affiliation = "Daily Planet")),
  person("Lois", "Lane"), person("Oscorp Inc.")
)

a_cff <- as_cff_person(persons)

a_cff

# Printed as Bibtex thanks to the method
toBibtex(a_cff)

# Or as person object
as.person(a_cff)


# Or you can use BibTeX style as input if you prefer

x <- "Frank Sinatra and Dean Martin and Davis, Jr., Sammy and Joey Bishop"

as_cff_person(x)

as_cff_person("Herbert von Karajan")

toBibtex(as_cff_person("Herbert von Karajan"))
}
\references{
\itemize{
\item Patashnik, Oren. "BIBTEXTING" February 1988.
\url{https://osl.ugr.es/CTAN/biblio/bibtex/base/btxdoc.pdf}.
\item Markey, Nicolas. "Tame the BeaST"
\emph{The B to X of BibTeX, Version 1.4} (October 2007).
\url{https://osl.ugr.es/CTAN/info/bibtex/tamethebeast/ttb_en.pdf}.
\item Decoret X (2007). "A summary of BibTex."\url{https://maverick.inria.fr/~Xavier.Decoret/resources/xdkbibtex/bibtex_summary.html#names}
}

See \strong{Examples} for more information.
}
\seealso{
Examples in \code{vignette("cffr", "cffr")} and \code{\link[utils:person]{utils::person()}}.

Learn more about the classes \verb{cff_pers_lst, cff_pers} classes in \link{cff_class}.

Coercing between \strong{R} classes with \strong{S3 Methods}:
\code{\link{as_bibentry}()},
\code{\link{as_cff}()},
\code{\link{cff_class}}
}
\concept{s3method}
