% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrome.R
\name{ensure_chrome}
\alias{ensure_chrome}
\title{Ensure Chrome is available, downloading if necessary}
\usage{
ensure_chrome(download = FALSE, verbose = TRUE)
}
\arguments{
\item{download}{If TRUE and Chrome is not found, attempt to download
Chrome for Testing (default FALSE).}

\item{verbose}{Print status messages (default TRUE).}
}
\value{
TRUE if Chrome is available (or was successfully downloaded),
FALSE otherwise.
}
\description{
Checks if Chrome is available and optionally downloads a standalone
Chrome for Testing if not found. This ensures Chrome-based rendering
works without requiring a system-wide Chrome installation.
}
\details{
When \code{download = TRUE}, this function will download "Chrome for Testing",
a standalone Chrome distribution designed for automation. The download
is approximately 150MB and is cached in the user's data directory.

Alternatively, you can:
\itemize{
\item Install Chrome/Chromium system-wide
\item Set the \code{CHROMOTE_CHROME} environment variable to point to an existing installation
}
}
\examples{
# Check and report status
ensure_chrome()

# Download Chrome if not available
\dontrun{ # Requires an external Chrome/Chromium installation 
ensure_chrome(download = TRUE)
}
}
