% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrome.R
\name{svg_to_pdf_chrome}
\alias{svg_to_pdf_chrome}
\title{Convert SVG to PDF using headless Chrome}
\usage{
svg_to_pdf_chrome(
  svg_input,
  output_path,
  background = "transparent",
  print_background = TRUE,
  timeout = 30
)
}
\arguments{
\item{svg_input}{SVG string or path to an SVG file.}

\item{output_path}{Output path for the PDF file.}

\item{background}{Background color for the HTML page (default "transparent").}

\item{print_background}{Whether to include CSS backgrounds in PDF (default TRUE).}

\item{timeout}{Maximum time in seconds to wait for page load (default 30).}
}
\value{
Path to the generated PDF file.
}
\description{
Renders an SVG to PDF using headless Chrome via the chromote package.
This method produces vector PDFs with perfect font rendering.
}
\examples{
\dontrun{ # It requires an external Chrome/Chromium installation 
svg <- svg_card("FAR", list(), list())
if (chrome_available()) {
  pdf_path <- svg_to_pdf_chrome(svg, tempfile(fileext = ".pdf"))
}
}
}
