% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_ageg_aggregation.R
\name{custom_ageg_aggregation}
\alias{custom_ageg_aggregation}
\title{Smart aggregation of cancer cases per age group}
\usage{
custom_ageg_aggregation(
  dat,
  ncan.min = 5,
  add.total = FALSE,
  ncan.lab = "ncan",
  py.lab = "py"
)
}
\arguments{
\item{dat}{tibble, a single cancer/sex/country tibble containing
cancer cases from a registry. It sould contains the column
ageg and ncan}

\item{ncan.min}{integer, the minimal number of cancer in
each category}

\item{add.total}{logical, should the 'total' category added to
the output dataset}

\item{ncan.lab}{character, the column label where cancer cases are stored}

\item{py.lab}{character, the column label where (optional) population at risk are stored}
}
\value{
aggregated dataset where all the age group contains at least
ncan.min cancers cases
}
\description{
Smart aggregation of cancer cases per age group
}
\examples{

dat <- 
  dplyr::tribble(
    ~ ageg, ~ ncan,
    '00_04', 0,
    '05_09', 0,
    '10_14', 0, 
    '15_19', 0,
    '20_24', 1,
    '25_29', 2,
    '30_34', 4,
    '35_39', 5,
    '40_44', 1,
    '45_49', 10,
    '50_54', 14,
    '55_59', 1,
    '60_64', 2,
    '65_69', 2,
    '70_74', 5,
    '75_79', 1,
    '80_84', 0,
    '85', 0
  )

custom_ageg_aggregation(dat, 0)
custom_ageg_aggregation(dat, 5)
custom_ageg_aggregation(dat, 10)
custom_ageg_aggregation(dat, 100)

}
