% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_config.R
\name{DatasetConfig}
\alias{DatasetConfig}
\title{Create a dataset configuration. This configuration allows CAMPSIS to know which
are the default depot and observed compartments.}
\usage{
DatasetConfig(
  defDepotCmt = 1,
  defObsCmt = 1,
  exportTSLD = FALSE,
  exportTDOS = FALSE,
  timeUnitDataset = "hour",
  timeUnitExport = "hour"
)
}
\arguments{
\item{defDepotCmt}{default depot compartment, integer}

\item{defObsCmt}{default observation compartment, integer}

\item{exportTSLD}{export column TSLD (time since last dose), logical}

\item{exportTDOS}{export column TDOS (time of last dose), logical}

\item{timeUnitDataset}{unit of time in dataset, character ('hour' by default)}

\item{timeUnitExport}{unit of time in export, character ('hour' by default)}
}
\value{
a dataset configuration
}
\description{
Create a dataset configuration. This configuration allows CAMPSIS to know which
are the default depot and observed compartments.
}
