% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-direct-std.R
\name{DirectStd}
\alias{DirectStd}
\title{Standardized Direct Effect of X on Y
Over a Specific Time Interval}
\usage{
DirectStd(phi, sigma, delta_t, from, to, med)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).
\code{phi} should have row and column names
pertaining to the variables in the system.}

\item{sigma}{Numeric matrix.
The process noise covariance matrix (\eqn{\boldsymbol{\Sigma}}).}

\item{delta_t}{Numeric.
Time interval
(\eqn{\Delta t}).}

\item{from}{Character string.
Name of the independent variable \eqn{X} in \code{phi}.}

\item{to}{Character string.
Name of the dependent variable \eqn{Y} in \code{phi}.}

\item{med}{Character vector.
Name/s of the mediator variable/s in \code{phi}.}
}
\value{
Returns an object
of class \code{ctmedeffect} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("DirectStd").}
\item{output}{The standardized direct effect.}
}
}
\description{
This function computes the standardized direct effect
of the independent variable \eqn{X}
on the dependent variable \eqn{Y}
through mediator variables \eqn{\mathbf{m}}
over a specific time interval \eqn{\Delta t}
using the first-order stochastic differential equation model's
drift matrix \eqn{\boldsymbol{\Phi}}
and process noise covariance matrix \eqn{\boldsymbol{\Sigma}}.
}
\details{
The standardized direct effect
of the independent variable \eqn{X}
on the dependent variable \eqn{Y}
relative to some mediator variables \eqn{\mathbf{m}}
is given by
\deqn{
    \mathrm{Direct}^{\ast}_{{\Delta t}_{i, j}}
    =
    \mathrm{Direct}_{{\Delta t}_{i, j}}
    \left(
    \frac{\sigma_{{x}_{j}}}{\sigma_{{y}_{i}}}
    \right)
  }
where
\eqn{\boldsymbol{\Phi}} denotes the drift matrix,
\eqn{\sigma_{{x}_{j}}} and \eqn{\sigma_{{y}_{i}}}
are the steady-state model-implied standard deviations
of the state independent and dependent variables, respectively, and
\eqn{\Delta t} the time interval.
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")
sigma <- matrix(
  data = c(
    0.24455556, 0.02201587, -0.05004762,
    0.02201587, 0.07067800, 0.01539456,
    -0.05004762, 0.01539456, 0.07553061
  ),
  nrow = 3
)
delta_t <- 1
DirectStd(
  phi = phi,
  sigma = sigma,
  delta_t = delta_t,
  from = "x",
  to = "y",
  med = "m"
)

}
\references{
Bollen, K. A. (1987).
Total, direct, and indirect effects in structural equation models.
Sociological Methodology, 17, 37.
\doi{10.2307/271028}

Deboeck, P. R., & Preacher, K. J. (2015).
No need to be discrete:
A method for continuous time mediation analysis.
Structural Equation Modeling: A Multidisciplinary Journal, 23 (1), 61–75.
\doi{10.1080/10705511.2014.973960}

Ryan, O., & Hamaker, E. L. (2021).
Time to intervene:
A continuous-time approach to network analysis and centrality.
Psychometrika, 87 (1), 214–252.
\doi{10.1007/s11336-021-09767-0}
}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{BootBeta}()},
\code{\link{BootBetaStd}()},
\code{\link{BootIndirectCentral}()},
\code{\link{BootMed}()},
\code{\link{BootMedStd}()},
\code{\link{BootTotalCentral}()},
\code{\link{DeltaBeta}()},
\code{\link{DeltaBetaStd}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaMedStd}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{IndirectStd}()},
\code{\link{MCBeta}()},
\code{\link{MCBetaStd}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCMedStd}()},
\code{\link{MCPhi}()},
\code{\link{MCPhiSigma}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{MedStd}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorTotalCentral}()},
\code{\link{Total}()},
\code{\link{TotalCentral}()},
\code{\link{TotalStd}()},
\code{\link{Trajectory}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Continuous Time Mediation Functions}
\keyword{cTMed}
\keyword{effects}
