% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_nina.R
\name{nina_warnings}
\alias{nina_warnings}
\title{List NINA travel warnings}
\usage{
nina_warnings(safe = TRUE, refresh = FALSE)
}
\arguments{
\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with warning metadata.

Includes \code{last_modified_time} and \code{effective_time} as POSIXct in Europe/Berlin.
}
\description{
List NINA travel warnings
}
\details{
The NINA API provides warnings and app data from the Bundesamt fuer
Bevoelkerungsschutz. This endpoint returns a list of travel warnings with
metadata. Official docs: https://nina.api.bund.dev.
}
\examples{
\dontrun{
nina_warnings()
}

}
\seealso{
\code{\link[=nina_warning]{nina_warning()}} for a single warning and \code{\link[=nina_mapdata]{nina_mapdata()}} for
map-based alerts.
}
