% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_entgeltatlas.R
\name{entgeltatlas_entgelte}
\alias{entgeltatlas_entgelte}
\title{Query Entgeltatlas data by KldB key}
\usage{
entgeltatlas_entgelte(
  kldb,
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{kldb}{KldB 2010 key (3-5 digits).}

\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with entgelt entries.
}
\description{
Query Entgeltatlas data by KldB key
}
\details{
The Entgeltatlas API provides wage statistics for occupational categories
identified by KldB keys. The API accepts optional filters for region, gender,
age, sector, and performance level. Official docs:
https://bundesapi.github.io/entgeltatlas-api/.

\strong{Recommended:} Configure OAuth2 via \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} with type \code{"oauth2"}.
If you provide a client secret, it fetches an OAuth token; otherwise it falls
back to sending the client ID as \code{X-API-Key}.
}
\examples{
\dontrun{
# Recommended: OAuth2 configuration
Sys.setenv(
  ENTGELTATLAS_API_KEY = "c4f0d292-9d0f-4763-87dd-d3f9e78fb006",
  ENTGELTATLAS_CLIENT_SECRET = "<client-secret>"
)
bunddev_auth_set("entgeltatlas",
  type = "oauth2",
  oauth_url = "https://rest.arbeitsagentur.de/oauth/gettoken_cc",
  env_var = "ENTGELTATLAS_API_KEY",
  oauth_secret_env = "ENTGELTATLAS_CLIENT_SECRET",
  oauth_default_id = "c4f0d292-9d0f-4763-87dd-d3f9e78fb006")
entgeltatlas_entgelte("84304", params = list(r = 1, g = 1))
}

}
