% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_unemployment.R
\name{plot_unemployment}
\alias{plot_unemployment}
\title{Plot Brazil's quarterly unemployment rate}
\usage{
plot_unemployment(data, language = "eng")
}
\arguments{
\item{data}{Tibble returned by \code{get_unemployment()}}

\item{language}{Language for column names: "pt" for Portuguese or "eng" (default) for English}
}
\value{
A ggplot2 object
}
\description{
Generates a ggplot2 line chart of unemployment rate in Brazil.
}
\examples{
\dontrun{
# Example 1: English version
unemployment_data <- get_unemployment(2020, 2024)
unemployment_plot <- plot_unemployment(unemployment_data)
print(unemployment_plot)

# Example 2: Portuguese version
dados_desemprego <- get_unemployment(2020, 2024, language = "pt")
grafico_desemprego <- plot_unemployment(dados_desemprego, language = "pt")
print(grafico_desemprego)
}
}
