% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_funs.R
\name{kmbayes_combine_lowmem}
\alias{kmbayes_combine_lowmem}
\alias{comb_bkmrfits_lowmem}
\title{Combine multiple BKMR chains in lower memory settings}
\usage{
kmbayes_combine_lowmem(
  fitkm.list,
  burnin = NULL,
  excludeburnin = FALSE,
  reorder = TRUE
)

comb_bkmrfits_lowmem(
  fitkm.list,
  burnin = NULL,
  excludeburnin = FALSE,
  reorder = TRUE
)
}
\arguments{
\item{fitkm.list}{output from \code{\link[bkmrhat]{kmbayes_parallel}}}

\item{burnin}{(numeric, or default=NULL) add in custom burnin (number of burnin iterations per chain).
If NULL, then default to half of the chain}

\item{excludeburnin}{(logical, default=FALSE) should burnin iterations be excluded from the final chains?
Note that all bkmr package functions automatically exclude burnin from calculations.}

\item{reorder}{(logical, default=TRUE) ensures that the first half of the combined chain contains
only the first half of each individual chain - this allows unaltered use
of standard functions from bkmr package, which automatically trims the first
half of the iterations. This can be used for posterior summaries, but
certain diagnostics may not work well (autocorrelation, effective sample size)
so the diagnostics should be done on the individual chains
#' @param ... arguments to \code{\link[bkmrhat]{as.mcmc.bkmrfit}}}
}
\value{
a \code{bkmrplusfit} object, which inherits from \code{bkmrfit}
(from the \code{\link[bkmr]{kmbayes}} function)
with multiple chains combined into a single object and additional parameters
given by \code{chain} and \code{iters}, which index the specific chains and
iterations for each posterior sample in the \code{bkmrplusfit} object
}
\description{
Combine multiple chains comprising BKMR fits at different starting
values. This function writes some results
to disk, rather than trying to process fully within memory which, in some cases,
will result in avoiding "out of memory" errors that can happen with kmbayes_combine.
}
\details{
Chains are not combined fully sequentially (see "reorder")
}
\examples{
\donttest{
# following example from https://jenfb.github.io/bkmr/overview.html
set.seed(111)
library(bkmr)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
set.seed(111)

future::plan(strategy = future::multisession, workers=2)
# run 4 parallel Markov chains (low iterations used for illustration)
fitkm.list <- kmbayes_parallel(nchains=2, y = y, Z = Z, X = X, iter = 500,
  verbose = FALSE, varsel = TRUE)
# use bkmr defaults for burnin, but keep them
bigkm = kmbayes_combine_lowmem(fitkm.list, excludeburnin=FALSE)
ests = ExtractEsts(bigkm) # defaults to keeping second half of samples
ExtractPIPs(bigkm)
pred.resp.univar <- PredictorResponseUnivar(fit = bigkm)
risks.overall <- OverallRiskSummaries(fit = bigkm, y = y, Z = Z, X = X,
  qs = seq(0.25, 0.75, by = 0.05), q.fixed = 0.5, method = "exact")

# additional objects that are not in a standard bkmrfit object:
summary(bigkm$iters) # note that this reflects how fits are re-ordered to reflect burnin
table(bigkm$chain)
}

closeAllConnections()

}
