% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_1.R
\docType{methods}
\name{plot,BIOMOD.formated.data,missing-method}
\alias{plot,BIOMOD.formated.data,missing-method}
\title{\code{plot} method for \code{\link{BIOMOD.formated.data}} and 
\code{\link{BIOMOD.formated.data.PA}} object class}
\usage{
\S4method{plot}{BIOMOD.formated.data,missing}(
  x,
  calib.lines = NULL,
  PA,
  run,
  plot.type,
  point.size = 1.5,
  plot.output,
  plot.valid = TRUE,
  plot.eval = TRUE,
  do.plot = TRUE,
  has.mask = FALSE,
  has.mask.eval = FALSE
)
}
\arguments{
\item{x}{a \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}}
object. Coordinates must be available to be able to use \code{plot}}

\item{calib.lines}{(\emph{optional, default} \code{NULL}) \cr
A \code{data.frame} object returned by \code{\link{get_calib_lines}} or 
\code{\link{bm_CrossValidation}} functions, to explore the distribution of calibration 
and validation datasets}

\item{PA}{(\emph{optional, default} \code{'all'}) \cr 
If \code{x} is a \code{\link{BIOMOD.formated.data.PA}} object, a \code{vector} 
containing pseudo-absence set to be represented}

\item{run}{(\emph{optional, default} \code{'all'}) \cr 
If \code{calib.lines} is provided, a \code{vector} containing repetition set to 
be represented}

\item{plot.type}{a \code{character} defining how occurrences will be represented. 
Must be \code{'points'} (\emph{default}, better when using fine-grained data) or 
\code{'raster'} (\emph{if environmental variables were given as a raster}, better 
when using coarse-grained data)}

\item{point.size}{(\emph{optional, default} \code{1.5}) \cr 
If \code{plot.type = 'points'}, a \code{numeric} to adjust the size of points}

\item{plot.output}{a \code{character} defining whether to return a single facet with 
all plots or a \code{list} of individual plots, must be \code{'facet'} (\emph{default}) 
or \code{list}}

\item{plot.valid}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} defining whether validation data should be separated on plot or not}

\item{plot.eval}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} defining whether evaluation data should be added to the plot or not}

\item{do.plot}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} defining whether the plot is to be rendered or not}

\item{has.mask}{\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} defining whether a mask for calibration data is available or not}

\item{has.mask.eval}{(\emph{optional, default} \code{FALSE}) \cr
A \code{logical} defining whether a mask for evaluation data is available or not}
}
\value{
a \code{list} with the data used to generate the plot and a
\code{ggplot2} object
}
\description{
Plot the spatial distribution of presences, absences and 
pseudo-absences among the different potential dataset (calibration, 
validation and evaluation). Available only if coordinates were given to 
\code{\link{BIOMOD_FormatingData}}.
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
# Format Data with true absences
myBiomodData <- BIOMOD_FormatingData(resp.name = myRespName,
                                     resp.var = myResp,
                                     resp.xy = myRespXY,
                                     expl.var = myExpl)
myBiomodData
plot(myBiomodData)


}
\author{
Rémi Lemaire-Patin, Hélène Blancheteau
}
