% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findAuthorWorks.r
\name{findAuthorWorks}
\alias{findAuthorWorks}
\title{Find Author's Co-authored Works}
\usage{
findAuthorWorks(author_name, data, partial_match = TRUE, exact_match = FALSE)
}
\arguments{
\item{author_name}{Character. The author's name to search for (case-insensitive)}

\item{data}{Data.frame. The bibliometric dataframe with AU and DI columns}

\item{partial_match}{Logical. If TRUE, allows partial name matching (default: TRUE)}

\item{exact_match}{Logical. If TRUE, requires exact name matching (default: FALSE)}
}
\value{
A data.frame with columns:
  \itemize{
    \item doi: DOI of the work
    \item author_position: Numerical position of the author in the author list
    \item total_authors: Total number of authors in the work
    \item all_authors: Complete list of authors for reference
    \item matched_name: The exact name variant that was matched
  }
}
\description{
Searches for an author's name in a bibliometric dataframe and returns 
the DOIs and author positions of their co-authored works.
}
\details{
The function searches through the AU column which contains author names 
separated by semicolons. It identifies the position of the target author
and returns comprehensive information about each matching work.
}
\examples{
\dontrun{
# Find works by "ARIA M"
works <- findAuthorWorks("ARIA M", M)

# Find works with exact matching
works_exact <- findAuthorWorks("PESTANA MH", M, exact_match = TRUE)

# Find works with partial matching disabled
works_full <- findAuthorWorks("MASSIMO ARIA", M, partial_match = FALSE)
}

}
\author{
Your Name
}
