% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixmod_gibbs_functions.R
\name{sample.phi.mixmod}
\alias{sample.phi.mixmod}
\title{Internal function to sample bin estimates for each movement variable}
\usage{
sample.phi.mixmod(alpha, nmaxclust, nbins, ndata.types, nmat)
}
\arguments{
\item{alpha}{numeric. A hyperparameter for the Dirichlet distribution.}

\item{nmaxclust}{numeric. A single number indicating the maximum number of
clusters to test.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
data stream. These must be in the same order as the columns within
\code{dat}.}

\item{ndata.types}{numeric. The number of data streams being analyzed.}

\item{nmat}{A list based on \code{\link{SummarizeDat}} C++ function to help
with multinomial draws.}
}
\value{
A list of proportion estimates that characterize distributions
  (bins) for each data stream and possible behavioral state.
}
\description{
Estimates values of \emph{phi} matrix for use in characterizing distributions
of the movement variables. Not for calling directly by users.
}
