% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metropolis_Hastings_Algorithms.R
\name{IndepMH}
\alias{IndepMH}
\title{Independence Metropolis-Hastings Algorithm}
\usage{
IndepMH(data, propob = NULL, posterior = NULL, iter = 1500,
  burn = 500, vscale = 1.5, start = NULL, prior = "Uniform",
  mu = 0, sig = 10)
}
\arguments{
\item{data}{data required for the posterior distribution}

\item{propob}{a list of mean and variance-covariance of the normal proposal distribution (default:NULL)}

\item{posterior}{the posterior distribution. It is set to null in order to use the logit posterior.
The user can specify log posterior as a function of parameters and data (pars,data)}

\item{iter}{number of random draws desired (default: 1500)}

\item{burn}{burn-in period for the MH algorithm (default: 500)}

\item{vscale}{a positive value to scale up or down the variance-covariance matrix in
the proposal distribution}

\item{start}{starting values of parameters for the MH algorithm.
It is automatically generated but the user can also specify.}

\item{prior}{the prior distribution (default: "Normal", alternative: "Uniform")}

\item{mu}{the mean of the normal prior distribution (default:0)}

\item{sig}{the variance of the normal prior distribution (default:10)}
}
\value{
val a list of matrix of draws pardraws and the acceptance rate
}
\description{
\code{IndepMH} computes random draws of parameters using a specified proposal distribution.
}
\examples{
y = indicat(faithful$waiting,70)
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
data = data.frame(y,x); propob<- lapl_aprx(y,x)
IndepMH_n<- IndepMH(data=data,propob,iter = 102, burn = 2) # prior="Normal"
IndepMH_u<- IndepMH(data=data,propob,prior="Uniform",iter = 102, burn = 2) # prior="Uniform"
par(mfrow=c(3,1));invisible(apply(IndepMH_n$Matpram,2,function(x)plot(density(x))))
invisible(apply(IndepMH_u$Matpram,2,function(x)plot(density(x))));par(mfrow=c(1,1))

}
