/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import bartMachine.StatToolbox;
import bartMachine.TreeArrayIllustration;
import bartMachine.TreeIllustration;
import bartMachine.bartMachineTreeNode;
import bartMachine.bartMachine_d_init;
import java.io.Serializable;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorSpecies;

public abstract class bartMachine_e_gibbs_base
extends bartMachine_d_init
implements Serializable {
    @Override
    public void Build() {
        StatToolbox.setUseXoshiro(this.use_xoshiro);
        if (this.seed != null) {
            StatToolbox.setSeed(this.seed);
        }
        this.SetupGibbsSampling();
        this.DoGibbsSampling();
    }

    protected void DoGibbsSampling() {
        while (this.gibbs_sample_num <= this.num_gibbs_total_iterations) {
            this.DoOneGibbsSample();
            this.FlushDataForSample(this.gibbs_samples_of_bart_trees[this.gibbs_sample_num - 1]);
            this.DeleteBurnInsOnPreviousSamples();
            ++this.gibbs_sample_num;
        }
    }

    protected void DoOneGibbsSample() {
        bartMachineTreeNode[] bartMachineTreeNodeArray = new bartMachineTreeNode[this.num_trees];
        TreeArrayIllustration treeArrayIllustration = new TreeArrayIllustration(this.gibbs_sample_num, this.unique_name);
        double[] dArray = new double[this.n];
        for (int i = 0; i < this.num_trees; ++i) {
            if (this.verbose) {
                this.GibbsSampleDebugMessage(i);
            }
            dArray = this.SampleTree(this.gibbs_sample_num, i, bartMachineTreeNodeArray, treeArrayIllustration);
            this.SampleMusWrapper(this.gibbs_sample_num, i);
        }
        this.SampleSigsq(this.gibbs_sample_num, this.getResidualsFromFullSumModel(this.gibbs_sample_num, dArray));
        if (this.tree_illust) {
            this.illustrate(treeArrayIllustration);
        }
    }

    protected void GibbsSampleDebugMessage(int n) {
        if (n == 0 && this.gibbs_sample_num % 100 == 0) {
            String string = "Iteration " + this.gibbs_sample_num + "/" + this.num_gibbs_total_iterations;
            if (this.num_cores > 1) {
                string = string + "  thread: " + (this.threadNum + 1);
            }
            if (ON_WINDOWS) {
                long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                long l2 = Runtime.getRuntime().maxMemory();
                string = string + "  mem: " + TreeIllustration.one_digit_format.format((double)l / 1000000.0) + "/" + TreeIllustration.one_digit_format.format((double)l2 / 1000000.0) + "MB";
            }
            System.out.println(string);
        }
    }

    protected void SampleMusWrapper(int n, int n2) {
        bartMachineTreeNode bartMachineTreeNode2 = this.gibbs_samples_of_bart_trees[n - 1][n2];
        bartMachine_e_gibbs_base.subtractInPlace(this.sum_resids_vec, bartMachineTreeNode2.yhats);
        bartMachineTreeNode bartMachineTreeNode3 = this.gibbs_samples_of_bart_trees[n][n2];
        double d = this.gibbs_samples_of_sigsq[n - 1];
        this.assignLeafValsBySamplingFromPosteriorMeanAndSigsqAndUpdateYhats(bartMachineTreeNode3, d);
        bartMachine_e_gibbs_base.addInPlace(this.sum_resids_vec, bartMachineTreeNode3.yhats);
    }

    private void DeleteBurnInsOnPreviousSamples() {
        if (this.gibbs_sample_num <= this.num_gibbs_burn_in + 1 && this.gibbs_sample_num >= 2) {
            this.gibbs_samples_of_bart_trees[this.gibbs_sample_num - 2] = null;
        }
    }

    protected void SampleSigsq(int n, double[] dArray) {
        double d;
        this.gibbs_samples_of_sigsq[n] = d = this.drawSigsqFromPosterior(n, dArray);
        this.updateLogSigsqTable(d);
    }

    protected double[] getResidualsFromFullSumModel(int n, double[] dArray) {
        bartMachineTreeNode bartMachineTreeNode2 = this.gibbs_samples_of_bart_trees[n][this.num_trees - 1];
        for (int i = 0; i < this.n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] - bartMachineTreeNode2.yhats[i];
        }
        return dArray;
    }

    protected double[] SampleTree(int n, int n2, bartMachineTreeNode[] bartMachineTreeNodeArray, TreeArrayIllustration treeArrayIllustration) {
        Object object;
        int n3;
        bartMachineTreeNode bartMachineTreeNode2 = this.gibbs_samples_of_bart_trees[n - 1][n2].clone();
        double[] dArray = new double[this.n];
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        int n4 = vectorSpecies.loopBound(this.n);
        for (n3 = 0; n3 < n4; n3 += vectorSpecies.length()) {
            object = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])this.y_trans, (int)n3);
            DoubleVector doubleVector = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])this.sum_resids_vec, (int)n3);
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])bartMachineTreeNode2.yhats, (int)n3);
            object.sub((Vector)doubleVector).add((Vector)doubleVector2).intoArray(dArray, n3);
        }
        while (n3 < this.n) {
            dArray[n3] = this.y_trans[n3] - this.sum_resids_vec[n3] + bartMachineTreeNode2.yhats[n3];
            ++n3;
        }
        bartMachineTreeNode2.updateWithNewResponsesRecursively(dArray);
        object = this.metroHastingsPosteriorTreeSpaceIteration(bartMachineTreeNode2, n2, this.accept_reject_mh, this.accept_reject_mh_steps);
        bartMachineTreeNodeArray[n2] = object;
        this.gibbs_samples_of_bart_trees[n] = bartMachineTreeNodeArray;
        treeArrayIllustration.AddTree((bartMachineTreeNode)object);
        return dArray;
    }

    protected abstract double drawSigsqFromPosterior(int var1, double[] var2);

    protected abstract bartMachineTreeNode metroHastingsPosteriorTreeSpaceIteration(bartMachineTreeNode var1, int var2, boolean[][] var3, char[][] var4);

    protected abstract void assignLeafValsBySamplingFromPosteriorMeanAndSigsqAndUpdateYhats(bartMachineTreeNode var1, double var2);

    private static void addInPlace(double[] dArray, double[] dArray2) {
        int n;
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray2, (int)n);
            doubleVector.add((Vector)doubleVector2).intoArray(dArray, n);
        }
        while (n < dArray.length) {
            int n3 = n;
            dArray[n3] = dArray[n3] + dArray2[n];
            ++n;
        }
    }

    private static void subtractInPlace(double[] dArray, double[] dArray2) {
        int n;
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray2, (int)n);
            doubleVector.sub((Vector)doubleVector2).intoArray(dArray, n);
        }
        while (n < dArray.length) {
            int n3 = n;
            dArray[n3] = dArray[n3] - dArray2[n];
            ++n;
        }
    }
}

