% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{delete_start_with}
\alias{delete_start_with}
\title{Deletes a pattern from the start of a string, or each of a vector of strings.}
\usage{
delete_start_with(s, vec)
}
\arguments{
\item{s}{the pattern (a single string) to be deleted from the start.}

\item{vec}{a vector of strings with unwanted starting strings (specified by \code{s}).}
}
\value{
string(s) with deleted patterns from the start.
}
\description{
\code{delete_start_with} is used for clean the column names in raw data.
For example, R adds "X" at the start of variable names. This function deletes
"X_"s from the column names. This can happen if the raw data have column
names such as "\verb{_CASE_ABX}". Check \code{\link[=clean_perch_data]{clean_perch_data()}} for
its actual usage.
}
\examples{
delete_start_with("X_",c("X_hello"))
delete_start_with("X_",c("X_hello","hello2"))
delete_start_with("X_",c("X_hello","hello2","X_hello3"))

}
