% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_save_incremental}
\alias{am_save_incremental}
\title{Save incremental changes}
\usage{
am_save_incremental(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
A raw vector containing the incremental changes. May be empty
(zero-length) if no new changes have been made since the last save.
}
\description{
Serializes only the changes made since the last call to \code{am_save()} or
\code{am_save_incremental()}. This is more efficient than saving the entire
document when only a few changes have been made.
}
\details{
Use \code{\link[=am_load_incremental]{am_load_incremental()}} to apply these changes to another document.
}
\examples{
doc <- am_create()
doc$key <- "value"
am_commit(doc)

# Save full document
full <- am_save(doc)

# Make more changes
doc$key2 <- "value2"
am_commit(doc)

# Save only the new changes
incremental <- am_save_incremental(doc)
length(incremental) < length(full)  # TRUE (smaller)

am_close(doc)

}
\seealso{
\code{\link[=am_load_incremental]{am_load_incremental()}}, \code{\link[=am_save]{am_save()}}
}
