% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_equal}
\alias{am_equal}
\title{Test document equality}
\usage{
am_equal(doc1, doc2)
}
\arguments{
\item{doc1}{An Automerge document}

\item{doc2}{An Automerge document}
}
\value{
A logical scalar: \code{TRUE} if the documents are equal, \code{FALSE}
otherwise.
}
\description{
Tests whether two Automerge documents have the same content. Documents
are equal if they have the same set of changes applied, regardless of
how they were created.
}
\examples{
doc1 <- am_create()
doc1$key <- "value"
am_commit(doc1)

doc2 <- am_clone(doc1)
am_equal(doc1, doc2)  # TRUE

doc2$key <- "different"
am_equal(doc1, doc2)  # FALSE

am_close(doc1)
am_close(doc2)

}
