% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_hash}
\alias{am_change_hash}
\title{Get the hash of a change}
\usage{
am_change_hash(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}},
\code{\link[=am_get_changes]{am_get_changes()}}, or \code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
A raw vector (32 bytes) containing the change hash
}
\description{
Returns the unique hash identifier of a change. Change hashes are used
to reference specific points in document history (e.g., with
\code{\link[=am_get_change_by_hash]{am_get_change_by_hash()}} or \code{\link[=am_fork]{am_fork()}}).
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")
am_commit(doc, "Add key")

history <- am_get_changes(doc)
hash <- am_change_hash(history[[1]])
hash
length(hash)  # 32 bytes

am_close(doc)

}
