% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{as_automerge}
\alias{as_automerge}
\title{Convert R list to Automerge document}
\usage{
as_automerge(x, doc = NULL, actor_id = NULL)
}
\arguments{
\item{x}{R list, vector, or scalar value to convert}

\item{doc}{Optional existing Automerge document. If NULL, creates a new one.}

\item{actor_id}{Optional actor ID for new documents (raw bytes or hex string)}
}
\value{
An Automerge document
}
\description{
Converts an R list to an Automerge document. This leverages the recursive
conversion built into \code{am_put()} from Phase 3, allowing nested structures
to be created in a single call.
}
\examples{
# Convert nested list to Automerge
data <- list(
  name = "Alice",
  age = 30L,
  scores = list(85, 90, 95),
  metadata = list(
    created = Sys.time(),
    tags = list("user", "active")
  )
)

doc <- as_automerge(data)
doc[["name"]]  # "Alice"
doc[["age"]]   # 30L

am_close(doc)

}
