% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{am_put_path}
\alias{am_put_path}
\title{Set value at path}
\usage{
am_put_path(doc, path, value, create_intermediate = TRUE)
}
\arguments{
\item{doc}{An Automerge document}

\item{path}{Character vector, numeric vector, or list of mixed types
specifying the path to the value}

\item{value}{Value to set at the path}

\item{create_intermediate}{Logical. If TRUE, creates intermediate maps
as needed. Default TRUE.}
}
\value{
The document (invisibly)
}
\description{
Set a value in an Automerge document using a path vector. Can optionally
create intermediate objects automatically.
}
\examples{
doc <- am_create()

# Create nested structure with automatic intermediate objects
am_put_path(doc, c("user", "address", "city"), "Boston")
am_put_path(doc, c("user", "address", "zip"), 02101L)
am_put_path(doc, c("user", "name"), "Alice")

# Verify
am_get_path(doc, c("user", "address", "city"))  # "Boston"
}
