% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_get_change_by_hash}
\alias{am_get_change_by_hash}
\title{Get a specific change by its hash}
\usage{
am_get_change_by_hash(doc, hash)
}
\arguments{
\item{doc}{An Automerge document}

\item{hash}{A raw vector containing the change hash (must be exactly 32 bytes)}
}
\value{
A raw vector containing the serialized change, or \code{NULL} if the
change hash is not found in the document.
}
\description{
Retrieves a change from the document's history by its unique hash identifier.
The hash is typically obtained from \code{am_get_heads()} or \code{am_get_changes()}.
}
\examples{
doc <- am_create()
doc$key <- "value"
am_commit(doc, "Add key")

# Get the current heads (change hashes)
heads <- am_get_heads(doc)
head_hash <- heads[[1]]

# Retrieve the change by its hash
change <- am_get_change_by_hash(doc, head_hash)
str(change)  # Raw vector
}
