% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support.R
\name{support}
\alias{support}
\alias{support,itemMatrix-method}
\alias{support,associations-method}
\title{Support Counting for Itemsets}
\usage{
support(x, transactions, ...)

\S4method{support}{itemMatrix}(
  x,
  transactions,
  type = c("relative", "absolute"),
  method = c("ptree", "tidlists"),
  reduce = FALSE,
  weighted = FALSE,
  verbose = FALSE,
  ...
)

\S4method{support}{associations}(
  x,
  transactions,
  type = c("relative", "absolute"),
  method = c("ptree", "tidlists"),
  reduce = FALSE,
  weighted = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{the set of itemsets for which support should be counted.}

\item{transactions}{the transaction data set used for mining.}

\item{...}{further arguments.}

\item{type}{a character string specifying if \code{"relative"} support or
\code{"absolute"} support (counts) are returned for the itemsets in
\code{x}.  (default: \code{"relative"})}

\item{method}{use \code{"ptree"} or \code{"tidlists"}. See Details Section.}

\item{reduce}{should unused items are removed before counting?}

\item{weighted}{should support be weighted by transactions weights stored as
column \code{"weight"} in \code{transactionInfo}?}

\item{verbose}{report progress?}
}
\value{
A numeric vector of the same length as \code{x} containing the
support values for the sets in \code{x}.
}
\description{
Provides the generic function \code{support()} and the methods to count support for
given \link{itemMatrix} and \link{associations} in a given \link{transactions}
data.
}
\details{
Normally, the support of frequent itemsets is very efficiently counted during
mining process using a set minimum support.
However, if only the support for specific itemsets (maybe itemsets with very low support)
is needed, or the support of a set of itemsets needs to be recalculated on
different \link{transactions} than they were mined on, then \code{support()} can be used.

Several methods for support counting are available:
\itemize{
\item \code{"ptree"} (default method): The counters for the itemsets
are organized in a prefix tree. The transactions are sequentially processed
and the corresponding counters in the prefix tree are incremented (see
Hahsler et al, 2008). This method is used by default since it is typically
significantly faster than transaction ID list intersection.
\item \code{"tidlists"}: support is counted using
transaction ID list intersection which is used by several fast mining
algorithms (e.g., by Eclat). However, Support is determined for each itemset
individually which is slow for a large number of long itemsets in dense
data.
}

To speed up counting, \code{reduce = TRUE} can be specified in control. Unused items
are removed from the transactions before counting.
}
\examples{
data("Income")

## find and some frequent itemsets
itemsets <- eclat(Income)[1:5]

## inspect the support returned by eclat
inspect(itemsets)

## count support in the database
support(items(itemsets), Income)
}
\references{
Michael Hahsler, Christian Buchta, and Kurt Hornik. Selective
association rule generation. \emph{Computational Statistics}, 23(2):303-315,
April 2008.
}
\seealso{
Other interest measures: 
\code{\link{confint}()},
\code{\link{coverage}()},
\code{\link{interestMeasure}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()}
}
\author{
Michael Hahsler and Christian Buchta
}
\concept{interest measures}
\keyword{models}
